/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.util.cache.WeakInterner;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfBizUser
implements TimestampedUser,
UserOrGroupStub,
Serializable {
    private static final long serialVersionUID = -3085079271696312159L;
    static final List<String> SUPPORTED_FIELDS = ImmutableList.builder().add((Object)"active").add((Object)"createdDate").add((Object)"directoryId").add((Object)"displayName").add((Object)"emailAddress").add((Object)"externalId").add((Object)"firstName").add((Object)"lastName").add((Object)"updatedDate").add((Object)"id").add((Object)"userName").add((Object)"deletedExternally").build();
    private static final WeakInterner<String> VALUE_INTERNER = WeakInterner.newWeakInterner();
    private final long id;
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final Date createdDate;
    private final Date updatedDate;
    private final String emailAddress;
    private final String firstName;
    private final String lastName;
    private final String displayName;
    private final String externalId;
    private final boolean deletedExternally;
    private String lowerUserName;
    private int hash;

    static OfBizUser from(GenericValue userGenericValue) {
        return OfBizUser.from(userGenericValue, false);
    }

    static OfBizUser from(GenericValue userGenericValue, boolean intern) {
        return new OfBizUser(userGenericValue, intern);
    }

    private OfBizUser(GenericValue userGenericValue, boolean intern) {
        Assertions.notNull((String)"userGenericValue", (Object)userGenericValue);
        String name = userGenericValue.getString("userName");
        String emailAddress = this.getEmailAddressFrom(userGenericValue);
        String firstName = userGenericValue.getString("firstName");
        String lastName = userGenericValue.getString("lastName");
        String displayName = userGenericValue.getString("displayName");
        String externalId = userGenericValue.getString("externalId");
        if (intern) {
            name = OfBizUser.internString(name);
            emailAddress = OfBizUser.internString(emailAddress);
            firstName = OfBizUser.internString(firstName);
            lastName = OfBizUser.internString(lastName);
            displayName = OfBizUser.internString(displayName);
            externalId = OfBizUser.internString(externalId);
        }
        this.id = userGenericValue.getLong("id");
        this.directoryId = userGenericValue.getLong("directoryId");
        this.name = name;
        this.active = BooleanUtils.toBoolean((int)userGenericValue.getInteger("active"));
        this.createdDate = userGenericValue.getTimestamp("createdDate");
        this.updatedDate = userGenericValue.getTimestamp("updatedDate");
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.displayName = displayName;
        this.externalId = externalId;
        this.deletedExternally = BooleanUtils.toBoolean((int)Optional.ofNullable(userGenericValue.getInteger("deletedExternally")).orElse(0));
    }

    static String internString(String s) {
        return VALUE_INTERNER.internOrNull(s);
    }

    private String getEmailAddressFrom(GenericValue userGenericValue) {
        String email = userGenericValue.getString("emailAddress");
        return email != null ? email : "";
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLowerName() {
        String lower = this.lowerUserName;
        if (lower == null) {
            this.lowerUserName = lower = IdentifierUtils.toLowerCase((String)this.name);
        }
        return lower;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isDeletedExternally() {
        return this.deletedExternally;
    }

    public String toString() {
        return this.name + ':' + this.directoryId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OfBizUser) {
            return this.equalsOfBizUser((OfBizUser)o);
        }
        return o instanceof User && this.equalsUser((User)o);
    }

    private boolean equalsOfBizUser(@Nonnull OfBizUser other) {
        return this.directoryId == other.directoryId && this.hashCode() == other.hashCode() && this.getLowerName().equals(other.getLowerName());
    }

    private boolean equalsUser(@Nonnull User other) {
        return this.directoryId == other.getDirectoryId() && this.getLowerName().equals(IdentifierUtils.toLowerCase((String)other.getName()));
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = UserComparator.hashCode((User)this);
        }
        return h;
    }

    public int compareTo(User other) {
        int nameCompare = this.getLowerName().compareTo(OfBizUser.getLowerName(other));
        if (nameCompare != 0) {
            return nameCompare;
        }
        long directoryId1 = this.directoryId;
        long directoryId2 = other.getDirectoryId();
        return directoryId1 == directoryId2 ? 0 : (directoryId1 < directoryId2 ? -1 : 1);
    }

    @Nonnull
    private static String getLowerName(@Nonnull User user) {
        if (user instanceof OfBizUser) {
            return ((OfBizUser)user).getLowerName();
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }
}

