/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mention;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@EventComponent
public class MentionEventListener {
    private final MentionService mentionService;
    private final NotificationSchemeManager notificationSchemeManager;
    private final NotificationFilterManager notificationFilterManager;

    public MentionEventListener(MentionService mentionService, NotificationSchemeManager notificationSchemeManager, NotificationFilterManager notificationFilterManager) {
        this.notificationSchemeManager = (NotificationSchemeManager)Assertions.notNull((String)"notificationSchemeManager", (Object)notificationSchemeManager);
        this.mentionService = (MentionService)Assertions.notNull((String)"mentionService", (Object)mentionService);
        this.notificationFilterManager = (NotificationFilterManager)Assertions.notNull((String)"notificationFilterManager", (Object)notificationFilterManager);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        Long eventTypeId = event.getEventTypeId();
        ApplicationUser remoteUser = event.getUser();
        Set recipients = StreamSupport.stream(this.notificationFilterManager.recomputeRecipients(this.notificationSchemeManager.getRecipients(event), this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.ISSUE_EVENT, event)).spliterator(), false).collect(Collectors.toSet());
        if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            Comment originalComment = (Comment)event.getParams().get("originalcomment");
            this.mentionService.sendCommentMentions(remoteUser, recipients, event.getComment(), originalComment);
        } else if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            this.mentionService.sendIssueCreateMentions(remoteUser, recipients, event.getIssue());
        } else if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            this.mentionService.sendIssueEditMentions(remoteUser, recipients, event.getIssue(), event.getComment());
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            this.mentionService.sendIssueEditMentions(remoteUser, recipients, event.getIssue(), event.getComment());
        } else if (event.getComment() != null) {
            this.mentionService.sendCommentMentions(remoteUser, recipients, event.getComment(), null);
        }
    }
}

