/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user;

import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UserEventListenerHandler
implements ListenerHandler {
    public List<? extends ListenerInvoker> getInvokers(Object o) {
        if (o instanceof UserEventListener) {
            return Collections.singletonList(new UserEventInvoker((UserEventListener)o));
        }
        return Collections.emptyList();
    }

    class UserEventInvoker
    implements ListenerInvoker {
        private final UserEventListener userEventListener;

        private UserEventInvoker(UserEventListener userEventListener) {
            this.userEventListener = userEventListener;
        }

        public Set<Class<?>> getSupportedEventTypes() {
            return Collections.singleton(UserEvent.class);
        }

        public void invoke(Object o) {
            if (o instanceof UserEvent) {
                UserEvent event = (UserEvent)o;
                if (event.getEventType() == 0) {
                    this.userEventListener.userSignup(event);
                } else if (event.getEventType() == 1) {
                    this.userEventListener.userCreated(event);
                } else if (event.getEventType() == 2) {
                    this.userEventListener.userForgotPassword(event);
                } else if (event.getEventType() == 3) {
                    this.userEventListener.userForgotUsername(event);
                } else if (event.getEventType() == 4) {
                    this.userEventListener.userCannotChangePassword(event);
                }
            }
        }

        public boolean supportAsynchronousEvents() {
            return false;
        }
    }
}

