/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.modzdetector.HashAlgorithm;
import com.atlassian.modzdetector.MD5HashAlgorithm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CustomisedConfigurationsHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomisedConfigurationsHealthCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/adminjiraserver/upgrading-jira-server-manual-938846939.html");
    @VisibleForTesting
    static final String CUSTOMISATION_DIR = "customisations";
    private final JiraProperties jiraProperties;
    private final JiraHomeStartupCheck jiraHomeStartupCheck;
    private final HashAlgorithm hashAlgorithm;

    public CustomisedConfigurationsHealthCheck(HealthCheck ... prerequisites) {
        this(JiraSystemProperties.getInstance(), JiraHomeStartupCheck.getInstance(), (HashAlgorithm)new MD5HashAlgorithm(), prerequisites);
    }

    @VisibleForTesting
    CustomisedConfigurationsHealthCheck(JiraProperties jiraProperties, JiraHomeStartupCheck jiraHomeStartupCheck, HashAlgorithm hashAlgorithm, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.jiraHomeStartupCheck = Objects.requireNonNull(jiraHomeStartupCheck);
        this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        boolean exists;
        String jiraHomePath = (String)this.jiraHomeStartupCheck.getJiraHomeDirectory().fold(failure -> {
            LOGGER.info("Jira Home not found. Unable to perform health check. This is most probably a new install.");
            return "";
        }, File::getAbsolutePath);
        File customisationsDirectory = Paths.get(jiraHomePath, CUSTOMISATION_DIR).toFile();
        boolean bl = exists = customisationsDirectory.exists() && customisationsDirectory.isDirectory();
        if (!exists) {
            return Collections.emptyList();
        }
        return this.getCustomisedFilePaths(customisationsDirectory).filter(files -> !files.isEmpty()).map(files -> this.toHealthCheckResult((List<Path>)files, customisationsDirectory)).orElse(Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<List<Path>> getCustomisedFilePaths(File customisationsDirectory) {
        try (Stream<Path> pathStream = Files.walk(customisationsDirectory.toPath(), new FileVisitOption[0]);){
            Optional<List<Path>> optional = Optional.of(pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !this.hasSameHash(customisationsDirectory, (Path)path)).collect(Collectors.toList()));
            return optional;
        }
        catch (IOException ioe) {
            LOGGER.error("Couldn't retrieve files in Customisations directory", (Throwable)ioe);
            return Optional.empty();
        }
    }

    private boolean hasSameHash(File customisationsDirectory, Path customisedFilePath) {
        try {
            String backedUpHash = this.hashAlgorithm.getHash(Files.readAllBytes(customisedFilePath));
            String relative = customisationsDirectory.toPath().relativize(customisedFilePath).toString();
            if (this.getTomcatDirectory().isPresent()) {
                String tomcatBase = this.getTomcatDirectory().get();
                File actualFile = Paths.get(tomcatBase, relative).toFile();
                if (actualFile.exists()) {
                    String actualHash = this.hashAlgorithm.getHash(Files.readAllBytes(actualFile.toPath()));
                    return backedUpHash.equals(actualHash);
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Couldn't perform the hash comparison", (Throwable)ioe);
        }
        return true;
    }

    private Optional<String> getTomcatDirectory() {
        return Stream.of("catalina.home", "catalina.base", "working.dir").map(prop -> Optional.ofNullable(this.jiraProperties.getProperty(prop))).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    private List<HealthCheckResult> toHealthCheckResult(List<Path> customisedConfigurations, File customisationsDirectory) {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("The listed configuration files contain custom changes. To keep your current configuration, re-apply these custom changes to the new version of the files during upgrade.")).addLineBreak().appendList(customisedConfigurations.stream().map(p -> HealthCheckMessageFormatter.string(customisationsDirectory.toPath().relativize((Path)p).toString())).collect(Collectors.toList())).addLineBreak().append(HealthCheckMessageFormatter.string("Note: Make sure you only copy over the changes not the entire files.")).addLineBreak();
        Event event = new Event(JohnsonEventType.UPGRADE.eventType(), "Custom changes have not been carried over", messageFormatter.toHtml(), JohnsonEventLevel.WARNING.eventLevel());
        event.addAttribute((Object)"dismissible", (Object)true);
        return HealthCheckResult.fail(this, event, KB_URL, "configuration-changes", messageFormatter.toText());
    }
}

