/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DatabaseCollationReader;
import com.atlassian.jira.database.SupportedCollations;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CollationHealthCheck
extends HealthCheckTemplate {
    public CollationHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        Optional maybeDbConfigManager = ComponentAccessor.getComponentSafely(DatabaseConfigurationManager.class);
        return maybeDbConfigManager.map(dbConfigManager -> this.performCheck((DatabaseConfigurationManager)dbConfigManager, DefaultOfBizConnectionFactory.getInstance())).orElse(Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected List<HealthCheckResult> performCheck(DatabaseConfigurationManager databaseConfigurationManager, OfBizConnectionFactory connectionFactory) {
        try (Connection connection = connectionFactory.getConnection();){
            DatabaseConfig databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
            String collation = DatabaseCollationReader.findCollation(connection, databaseConfig);
            if (!SupportedCollations.isSupported(databaseConfig, collation)) {
                Collection<String> supportedCollationsList = SupportedCollations.forDatabase(databaseConfig);
                HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
                if (supportedCollationsList.isEmpty()) {
                    List<HealthCheckResult> list = this.reportUnknownDatabase(messageFormatter);
                    return list;
                }
                List<HealthCheckResult> list = this.reportUnsupportedCollation(databaseConfigurationManager, collation, supportedCollationsList, messageFormatter);
                return list;
            }
            List<HealthCheckResult> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
            messageFormatter.append(HealthCheckMessageFormatter.string("The database collation could not be read. An unsupported collation could cause errors.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on supported collations."));
            return this.createWarning("We can't tell what collation your database is using", messageFormatter);
        }
    }

    private List<HealthCheckResult> reportUnsupportedCollation(DatabaseConfigurationManager databaseConfigurationManager, String collation, Collection<String> supportedCollationsList, HealthCheckMessageFormatter f) {
        f.append(HealthCheckMessageFormatter.string("Your " + this.getDatabaseType(databaseConfigurationManager) + " database is currently using an unsupported collation: " + collation + ". You should change this to a supported collation:")).appendList(supportedCollationsList.stream().map(HealthCheckMessageFormatter::string).collect(Collectors.toList())).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on supported collations."));
        return this.createWarning("Your database is using an unsupported collation", f);
    }

    private List<HealthCheckResult> reportUnknownDatabase(HealthCheckMessageFormatter f) {
        f.append(HealthCheckMessageFormatter.string("When your database is not supported, you may lose some functionality. We recommend always using a supported database."));
        return this.createWarning("We can't tell what database you're using", f);
    }

    private List<HealthCheckResult> createWarning(String desc, HealthCheckMessageFormatter message) {
        Event event = new Event(JohnsonEventType.DATABASE.eventType(), desc, message.toHtml(), EventLevels.warning());
        event.addAttribute((Object)"dismissible", (Object)true);
        return HealthCheckResult.fail(this, event, UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/KdxKLg"), "database-collation", message.toText());
    }

    private String getDatabaseType(DatabaseConfigurationManager databaseConfigurationManager) {
        return databaseConfigurationManager.getDatabaseConfiguration().getDatabaseType();
    }
}

