/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.MySQL57DefaultRowFormatChecker;
import com.atlassian.jira.config.database.MySQL57OrLaterVersionPredicate;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySql57ModeHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(MySql57ModeHealthCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/sIkjN");
    private final DatabaseConfigurationManager manager;

    public static MySql57ModeHealthCheck createInstance(HealthCheck ... prerequisites) {
        return new MySql57ModeHealthCheck((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class), prerequisites);
    }

    MySql57ModeHealthCheck(DatabaseConfigurationManager databaseConfigurationManager, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.manager = databaseConfigurationManager;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.DATABASE_CONFIGURED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return Optional.ofNullable(this.manager).map(manager -> {
            try {
                if (!manager.getDatabaseConfiguration().getDatabaseType().equals(DatabaseType.MY_SQL57.getTypeName())) return null;
                try (Connection conn = manager.getDatabaseConfiguration().getDatasource().getConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());){
                    boolean versionCorrect = new MySQL57OrLaterVersionPredicate().test(conn);
                    boolean configurationProper = new MySQL57DefaultRowFormatChecker().test(conn);
                    if (!versionCorrect) {
                        List<HealthCheckResult> list = this.createHealthCheckResult(this.createErrorMessage());
                        return list;
                    }
                    if (configurationProper) return null;
                    List<HealthCheckResult> list = this.createHealthCheckResult(this.createServerConfigErrorMessage());
                    return list;
                }
                catch (SQLException ex) {
                    return this.createHealthCheckResult(this.createErrorMessage());
                }
            }
            catch (BootstrapException ex) {
                log.error("There is database configuration error!", (Throwable)ex);
                return this.createHealthCheckResult(this.createErrorMessage());
            }
        }).orElse(Collections.emptyList());
    }

    private List<HealthCheckResult> createHealthCheckResult(HealthCheckMessageFormatter messageFormatter) {
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "We've found an error in MySQL supported version!", messageFormatter.toHtml(), EventLevels.fatal()), KB_URL, "mysql-version-incompatibility", messageFormatter.toText());
    }

    private HealthCheckMessageFormatter createErrorMessage() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The database type in your "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("dbconfig.xml")), HealthCheckMessageFormatter.string(" is set up to MySQl 5.7+ and your MySQL version is 5.6 or lower. Consider using MySQL 5.6 database type instead")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on changing database type."));
        return messageFormatter;
    }

    private HealthCheckMessageFormatter createServerConfigErrorMessage() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The database setup is not supporting utf8mb4")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on setting up MySQL 5.7."));
        return messageFormatter;
    }
}

