/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UnsupportedHsqlHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/9AONN");

    public UnsupportedHsqlHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.DATABASE_CONFIGURED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return this.performCheck((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class));
    }

    @VisibleForTesting
    List<HealthCheckResult> performCheck(DatabaseConfigurationManager databaseConfigurationManager) {
        if (databaseConfigurationManager.getDatabaseConfiguration().isHSql()) {
            return this.fatalHealthCheckResult();
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> fatalHealthCheckResult() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("HSQL was an evaluation database previously used by JIRA, and it's no longer supported. You can upgrade JIRA to an earlier version to migrate to the supported H2 database, but H2 is not recommended for a production instance.").addLineBreak(), HealthCheckMessageFormatter.string("See our documentation for more information on upgrading your JIRA instance."));
        return HealthCheckResult.fail(this, new Event(JohnsonEventType.DATABASE.eventType(), "We've detected that your JIRA instance is using an unsupported database", messageFormatter.toHtml(), EventLevels.fatal()), KB_URL, "hsql-unsupported", messageFormatter.toText());
    }
}

