/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.health.web.JohnsonEventSerializer;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.johnson.event.Event;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
class InteractiveJohnsonEventSerializer
implements JohnsonEventSerializer {
    InteractiveJohnsonEventSerializer() {
    }

    @Override
    @Nonnull
    public JSONObject toJSON(Event johnsonEvent) {
        JSONObject eventJSON = new JSONObject();
        try {
            String eventId;
            String urlString;
            eventJSON.put("title", (Object)this.getTitle(johnsonEvent)).put("description", (Object)this.getDescription(johnsonEvent)).put("level", (Object)this.getLevel(johnsonEvent)).put("dismissible", (Object)this.getDismissible(johnsonEvent));
            URL helpLink = this.getHelpLink(johnsonEvent);
            if (helpLink != null && StringUtils.isNotBlank((CharSequence)(urlString = helpLink.toString()))) {
                eventJSON.put("helpLink", (Object)urlString);
            }
            if ((eventId = this.getEventId(johnsonEvent)) != null) {
                eventJSON.put("eventId", (Object)eventId);
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Failed to serialize: " + johnsonEvent, e);
        }
        return eventJSON;
    }

    private String getTitle(Event event) throws JSONException {
        String category = event.getKey().getDescription();
        String title = event.getDesc();
        return String.format("%s: %s", category, title);
    }

    private String getDescription(Event event) throws JSONException {
        return event.getException();
    }

    private Boolean getDismissible(Event event) {
        return Boolean.TRUE.equals(event.getAttribute((Object)"dismissible"));
    }

    private String getLevel(Event event) {
        return event.getLevel().getLevel();
    }

    private URL getHelpLink(Event event) throws JSONException {
        return (URL)event.getAttribute((Object)"helpUrl");
    }

    private String getEventId(Event event) throws JSONException {
        return (String)event.getAttribute((Object)"eventKey");
    }
}

