/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.health.web.JohnsonEventCollectionSerializer;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.EventPredicates;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.setup.SetupConfig;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;

public final class JohnsonPageDataProvider {
    static final String HIDE_EVENT_DETAILS = "hide.system.error.details";
    private final JohnsonEventCollectionSerializer eventCollectionSerializer;
    private final JohnsonEventContainer johnsonContainer;
    private final SetupConfig setupConfig;
    private final Supplier<Boolean> healthCheckCompleteSupplier;
    private final Supplier<Optional<GlobalPermissionManager>> globalPermissionManagerSupplier;

    @VisibleForTesting
    JohnsonPageDataProvider(JohnsonEventContainer johnsonContainer, JohnsonEventCollectionSerializer eventCollectionSerializer, Supplier<Optional<GlobalPermissionManager>> globalPermissionManagerSupplier, SetupConfig setupConfig, Supplier<Boolean> healthCheckCompleteSupplier) {
        this.johnsonContainer = johnsonContainer;
        this.eventCollectionSerializer = eventCollectionSerializer;
        this.globalPermissionManagerSupplier = globalPermissionManagerSupplier;
        this.setupConfig = setupConfig;
        this.healthCheckCompleteSupplier = healthCheckCompleteSupplier;
    }

    public static JohnsonPageDataProvider createInstance(@Nonnull ServletContext context) {
        return new JohnsonPageDataProvider(Johnson.getEventContainer((ServletContext)context), new JohnsonEventCollectionSerializer(context.getContextPath()), ComponentAccessor.safeSupplierOf(GlobalPermissionManager.class), Johnson.getConfig().getSetupConfig(), HealthChecks::isComplete);
    }

    @Nonnull
    public JSONObject asJSON() {
        try {
            JSONObject json = new JSONObject().putOpt("canAuthoriseUsers", (Object)this.canAuthoriseUsers()).putOpt("checksComplete", (Object)this.areHealthChecksComplete());
            if (StringUtils.isBlank((CharSequence)JiraSystemProperties.getInstance().getProperty(HIDE_EVENT_DETAILS))) {
                json.putOpt("events", (Object)this.eventCollectionSerializer.toJSON(this.johnsonContainer.getEvents()));
            } else if (this.johnsonContainer.hasEvent(EventPredicates.type((EventType)EventType.get((String)"reindex")))) {
                json.putOpt("events", (Object)this.eventCollectionSerializer.toJSON(this.johnsonContainer.getEvents(EventPredicates.type((EventType)EventType.get((String)"reindex")))));
            } else if (this.startupBlocked()) {
                json.putOpt("errorsPresentButHidden", (Object)true);
            }
            return json;
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to create JSON response for Johnson Page", e);
        }
    }

    private boolean areHealthChecksComplete() {
        return this.healthCheckCompleteSupplier.get();
    }

    private boolean canAuthoriseUsers() {
        if (!this.globalPermissionManagerSupplier.get().isPresent()) {
            return false;
        }
        try {
            return this.setupConfig.isSetup();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean startupBlocked() {
        return this.johnsonContainer.hasEvent(JohnsonEventPredicates.blocksStartup());
    }
}

