/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class ResourceBundleCacheCleaner {
    private final Supplier<PluginAccessor> pluginAccessor;
    private final JiraProperties jiraProperties;

    public ResourceBundleCacheCleaner(ComponentLocator locator, JiraProperties jiraProperties) {
        this.jiraProperties = jiraProperties;
        this.pluginAccessor = locator.getComponentSupplier(PluginAccessor.class);
    }

    public void cleanPluginBundlesFromResourceBundleCache() {
        if (!this.jiraProperties.isResourceBundleCacheCleaningDisabled()) {
            ArrayList enabledPlugins = Lists.newArrayList((Iterable)((PluginAccessor)this.pluginAccessor.get()).getEnabledPlugins());
            for (Plugin plugin : enabledPlugins) {
                ClassLoader pluginClassLoader = plugin.getClassLoader();
                if (!this.isPluginClassLoader(pluginClassLoader)) continue;
                ResourceBundle.clearCache(pluginClassLoader);
            }
        }
    }

    private boolean isPluginClassLoader(ClassLoader pluginClassLoader) {
        return pluginClassLoader != null && pluginClassLoader.getClass().getName().startsWith(BundleClassLoaderAccessor.class.getName());
    }
}

