/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.imports.project.parser.ChangeGroupParserImpl;
import com.atlassian.jira.imports.project.transformer.ChangeGroupTransformer;
import com.atlassian.jira.imports.project.transformer.ChangeGroupTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeGroupPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(ChangeGroupPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private ChangeGroupParser changegroupParser;
    private ChangeGroupTransformer changeGroupTransformer;

    public ChangeGroupPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("ChangeGroup".equals(entityName)) {
            ExternalChangeGroup externalChangeGroup = this.getChangeGroupParser().parse(attributes);
            ExternalChangeGroup transformedChangeGroup = this.getChangeGroupTransformer().transform(this.projectImportMapper, externalChangeGroup);
            if (transformedChangeGroup.getIssueId() != null) {
                this.execute(() -> {
                    Long changeGroupId = this.projectImportPersister.createEntity(this.getChangeGroupParser().getEntityRepresentation(transformedChangeGroup));
                    if (changeGroupId != null) {
                        this.projectImportMapper.getChangeGroupMapper().mapValue(externalChangeGroup.getId(), changeGroupId.toString());
                    } else {
                        String issueKey = this.backupSystemInformation.getIssueKeyForId(externalChangeGroup.getIssueId());
                        this.projectImportResults.addError(this.projectImportResults.getI18n().getText("admin.errors.project.import.change.group.error", externalChangeGroup.getId(), issueKey));
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalChangeGroup.getIssueId());
                log.warn("Not creating change group with id '" + externalChangeGroup.getId() + "' for backup issue '" + issueKey + "', the issue has not been mapped in the new system.");
            }
        }
    }

    ChangeGroupTransformer getChangeGroupTransformer() {
        if (this.changeGroupTransformer == null) {
            this.changeGroupTransformer = new ChangeGroupTransformerImpl();
        }
        return this.changeGroupTransformer;
    }

    ChangeGroupParser getChangeGroupParser() {
        if (this.changegroupParser == null) {
            this.changegroupParser = new ChangeGroupParserImpl();
        }
        return this.changegroupParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

