/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalEntityProperty;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.imports.project.parser.ChangeGroupParserImpl;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.imports.project.parser.ChangeItemParserImpl;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.parser.EntityPropertyParser;
import com.atlassian.jira.imports.project.parser.EntityPropertyParserImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.imports.project.parser.UserAssociationParserImpl;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class IssueRelatedEntitiesPartitionHandler
implements ImportOfBizEntityHandler {
    private final BackupProject backupProject;
    private final ProjectImportTemporaryFiles projectImportTemporaryFiles;
    private final Map<String, ModelEntity> modelEntityMap;
    private final GenericDelegator delegator;
    private final Set<Long> changeGroupIds;
    private final Set<Long> commentIds;
    private ChangeGroupParser changeGroupParser;
    private ChangeItemParser changeItemParser;
    private UserAssociationParser userAssociationParser;
    private EntityPropertyParser entityPropertyParser;
    private NodeAssociationParser nodeAssocationParser;
    private IssueLinkParser issueLinkParser;
    private CommentParser commentParser;
    private int entityCount = 0;
    private int secondDegreeEntityCount = 0;
    private String currentEntity;
    private PrintWriter printWriter;

    public IssueRelatedEntitiesPartitionHandler(BackupProject backupProject, ProjectImportTemporaryFiles projectImportTemporaryFiles, List<ModelEntity> modelEntities, DelegatorInterface delegatorInterface) {
        this.backupProject = backupProject;
        this.projectImportTemporaryFiles = projectImportTemporaryFiles;
        this.delegator = GenericDelegator.getGenericDelegator((String)delegatorInterface.getDelegatorName());
        this.modelEntityMap = new HashMap<String, ModelEntity>();
        this.changeGroupIds = new HashSet<Long>();
        this.commentIds = new HashSet<Long>();
        for (ModelEntity modelEntity : modelEntities) {
            String entityName = modelEntity.getEntityName();
            this.modelEntityMap.put(entityName, modelEntity);
        }
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        boolean saveEntity;
        ModelEntity modelEntity = this.modelEntityMap.get(entityName);
        if (modelEntity == null) {
            return;
        }
        if ("NodeAssociation".equals(entityName)) {
            saveEntity = this.handleNodeAssociation(attributes);
        } else if ("IssueLink".equals(entityName)) {
            saveEntity = this.handleIssueLink(attributes);
        } else if ("ChangeItem".equals(entityName)) {
            saveEntity = false;
            if (this.handleChangeItem(attributes)) {
                this.saveSecondDegreeEntity(modelEntity, attributes);
            }
        } else if ("UserAssociation".equals(entityName)) {
            saveEntity = this.handleVotersAndWatchers(attributes);
        } else if ("EntityProperty".equals(entityName)) {
            saveEntity = this.handleEntityProperty(modelEntity, attributes);
        } else {
            String issueId = attributes.get("issue");
            saveEntity = this.backupProject.containsIssue(issueId);
        }
        if (saveEntity) {
            this.handleChangeGroup(entityName, attributes);
            this.handleComment(entityName, attributes);
            this.writeXmlText(entityName, attributes, modelEntity);
            ++this.entityCount;
        }
    }

    private void saveSecondDegreeEntity(ModelEntity modelEntity, Map<String, String> attributes) throws ParseException {
        String entityName = modelEntity.getEntityName();
        this.writeXmlText(entityName, attributes, modelEntity);
        ++this.secondDegreeEntityCount;
    }

    private void writeXmlText(String entityName, Map<String, String> attributes, ModelEntity modelEntity) throws ParseException {
        if (!entityName.equals(this.currentEntity)) {
            this.endDocument();
        }
        if (this.printWriter == null) {
            try {
                this.currentEntity = entityName;
                this.printWriter = this.projectImportTemporaryFiles.getWriter(entityName);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        GenericEntity genericEntity = new GenericEntity(this.delegator, modelEntity, attributes);
        genericEntity.writeXmlText(this.printWriter, null);
    }

    private boolean handleEntityProperty(ModelEntity modelEntity, Map<String, String> attributes) throws ParseException {
        ExternalEntityProperty entityProperty = this.getEntityPropertyParser().parse(attributes);
        if (EntityPropertyType.ISSUE_PROPERTY.getDbEntityName().equals(entityProperty.getEntityName())) {
            return this.backupProject.containsIssue(String.valueOf(entityProperty.getEntityId()));
        }
        if (EntityPropertyType.COMMENT_PROPERTY.getDbEntityName().equals(entityProperty.getEntityName()) && this.commentIds.contains(entityProperty.getEntityId())) {
            this.saveSecondDegreeEntity(modelEntity, attributes);
            return false;
        }
        if (EntityPropertyType.CHANGE_HISTORY_PROPERTY.getDbEntityName().equals(entityProperty.getEntityName()) && this.changeGroupIds.contains(entityProperty.getEntityId())) {
            this.saveSecondDegreeEntity(modelEntity, attributes);
            return false;
        }
        return false;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public int getSecondDegreeEntityCount() {
        return this.secondDegreeEntityCount;
    }

    private boolean handleVotersAndWatchers(Map<String, String> attributes) throws ParseException {
        ExternalVoter externalVoter = this.getUserAssociationParser().parseVoter(attributes);
        if (externalVoter != null) {
            return this.backupProject.containsIssue(externalVoter.getIssueId());
        }
        ExternalWatcher externalWatcher = this.getUserAssociationParser().parseWatcher(attributes);
        if (externalWatcher != null) {
            return this.backupProject.containsIssue(externalWatcher.getIssueId());
        }
        return false;
    }

    private boolean handleChangeItem(Map<String, String> attributes) throws ParseException {
        ExternalChangeItem externalChangeItem = this.getChangeItemParser().parse(attributes);
        try {
            Long groupId = new Long(externalChangeItem.getChangeGroupId());
            return this.changeGroupIds.contains(groupId);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse the changeGroup id'" + externalChangeItem.getChangeGroupId() + "' for change item.");
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.printWriter = null;
    }

    public Map<String, ModelEntity> getRegisteredHandlers() {
        return Collections.unmodifiableMap(this.modelEntityMap);
    }

    private void handleComment(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalComment externalComment;
        if ("Action".equals(entityName) && (externalComment = this.getCommentParser().parse(attributes)) != null) {
            String externalCommentId = externalComment.getId();
            if (externalCommentId != null) {
                try {
                    Long id = new Long(externalCommentId);
                    this.commentIds.add(id);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unable to parse the id for changeGroup '" + externalCommentId + "'");
                }
            } else {
                throw new ParseException("Encountered a Comment entry without an id, this should not happen");
            }
        }
    }

    private void handleChangeGroup(String entityName, Map<String, String> attributes) throws ParseException {
        if ("ChangeGroup".equals(entityName)) {
            ExternalChangeGroup externalChangeGroup = this.getChangeGroupParser().parse(attributes);
            String idStr = externalChangeGroup.getId();
            if (idStr != null) {
                try {
                    Long id = new Long(idStr);
                    this.changeGroupIds.add(id);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unable to parse the id for changeGroup '" + idStr + "'");
                }
            } else {
                throw new ParseException("Encountered a ChangeGroup entry without an id, this should not happen.");
            }
        }
    }

    private boolean handleIssueLink(Map<String, String> attributes) throws ParseException {
        ExternalLink externalLink = this.getIssueLinkParser().parse(attributes);
        return this.backupProject.containsIssue(externalLink.getSourceId()) || this.backupProject.containsIssue(externalLink.getDestinationId());
    }

    private boolean handleNodeAssociation(Map<String, String> attributes) throws ParseException {
        ExternalNodeAssociation externalNodeAssociation = this.getNodeAssociationParser().parse(attributes);
        if ("Issue".equals(externalNodeAssociation.getSourceNodeEntity()) && ("IssueVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueFixVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueComponent".equals(externalNodeAssociation.getAssociationType()))) {
            return this.backupProject.containsIssue(externalNodeAssociation.getSourceNodeId());
        }
        return false;
    }

    private NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    private IssueLinkParser getIssueLinkParser() {
        if (this.issueLinkParser == null) {
            this.issueLinkParser = new IssueLinkParserImpl();
        }
        return this.issueLinkParser;
    }

    private ChangeGroupParser getChangeGroupParser() {
        if (this.changeGroupParser == null) {
            this.changeGroupParser = new ChangeGroupParserImpl();
        }
        return this.changeGroupParser;
    }

    private ChangeItemParser getChangeItemParser() {
        if (this.changeItemParser == null) {
            this.changeItemParser = new ChangeItemParserImpl();
        }
        return this.changeItemParser;
    }

    UserAssociationParser getUserAssociationParser() {
        if (this.userAssociationParser == null) {
            this.userAssociationParser = new UserAssociationParserImpl();
        }
        return this.userAssociationParser;
    }

    EntityPropertyParser getEntityPropertyParser() {
        if (this.entityPropertyParser == null) {
            this.entityPropertyParser = new EntityPropertyParserImpl();
        }
        return this.entityPropertyParser;
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }
}

