/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.populator;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupOverviewBuilder;
import com.atlassian.jira.imports.project.parser.OSPropertyParser;
import com.atlassian.jira.imports.project.populator.BackupOverviewPopulator;
import java.util.Map;

public class SystemInfoPopulator
extends OSPropertyParser
implements BackupOverviewPopulator {
    private static final String JIRA_PROPERTIES_KEY = "jira.properties";
    private String buildNumberId = null;
    private String editionId = null;
    private String allowUnassignedId = null;

    @Override
    public void populate(BackupOverviewBuilder backupOverviewBuilder, String elementName, Map attributes) throws ParseException {
        String value;
        String id;
        if (elementName == null) {
            throw new IllegalArgumentException("'elementName' cannot be null.");
        }
        if (elementName.equals("OSPropertyEntry")) {
            id = this.getID(attributes);
            String entityName = this.getEntityName(attributes);
            if (JIRA_PROPERTIES_KEY.equals(entityName)) {
                String propertyKey = this.getPropertyKey(attributes);
                if ("jira.version.patched".equals(propertyKey)) {
                    this.buildNumberId = id;
                }
                if ("jira.edition".equals(propertyKey)) {
                    this.editionId = id;
                }
                if ("jira.option.allowunassigned".equals(propertyKey)) {
                    this.allowUnassignedId = id;
                }
            }
        }
        if (elementName.equals("OSPropertyString")) {
            id = this.getID(attributes);
            value = this.getValue(attributes);
            if (id != null) {
                if (id.equals(this.buildNumberId)) {
                    backupOverviewBuilder.setBuildNumber(value);
                }
                if (id.equals(this.editionId)) {
                    backupOverviewBuilder.setEdition(value);
                }
            }
        }
        if (elementName.equals("OSPropertyNumber")) {
            id = this.getID(attributes);
            value = this.getValue(attributes);
            if (id != null && id.equals(this.allowUnassignedId)) {
                backupOverviewBuilder.setUnassignedIssuesAllowed(this.parseNumberAsBoolean(value));
            }
        }
    }
}

