/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import javax.annotation.concurrent.ThreadSafe;

interface DelayCloseable
extends Closeable {
    public void open();

    public void closeWhenDone();

    @ThreadSafe
    public static final class Helper
    implements DelayCloseable {
        private final Closeable closable;
        private final UsageTracker usageTracker = new UsageTracker();

        Helper(Closeable closable) {
            this.closable = closable;
        }

        @Override
        public void open() {
            if (!this.usageTracker.incrementUsage()) {
                throw new AlreadyClosedException();
            }
        }

        @Override
        public void closeWhenDone() {
            if (!this.usageTracker.close(this.closable)) {
                throw new AlreadyClosedException();
            }
        }

        @Override
        public void close() {
            if (!this.usageTracker.decrement(this.closable)) {
                throw new AlreadyClosedException();
            }
        }

        public int usageCount() {
            return this.usageTracker.count.get();
        }

        boolean isCloseWhenDone() {
            return this.usageTracker.closeWhenDone.get();
        }

        boolean isClosed() {
            return this.usageTracker.count.get() == 0 && this.usageTracker.closeWhenDone.get();
        }

        private static class UsageTracker {
            private final AtomicInteger count = new AtomicInteger(0);
            private final AtomicBoolean closeWhenDone = new AtomicBoolean(false);

            private UsageTracker() {
            }

            synchronized boolean incrementUsage() {
                if (this.closeWhenDone.get()) {
                    return false;
                }
                this.count.incrementAndGet();
                return true;
            }

            boolean decrement(Closeable closeEffect) {
                return this.executeUnderLockClosingWhenDone(closeEffect, () -> {
                    if (this.count.get() == 0) {
                        return false;
                    }
                    this.count.decrementAndGet();
                    return true;
                });
            }

            boolean close(Closeable closeEffect) {
                return this.executeUnderLockClosingWhenDone(closeEffect, () -> this.closeWhenDone.compareAndSet(false, true));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeUnderLockClosingWhenDone(Closeable closeEffect, BooleanSupplier operation) {
                boolean shouldRunClose;
                boolean result;
                UsageTracker usageTracker = this;
                synchronized (usageTracker) {
                    result = operation.getAsBoolean();
                    shouldRunClose = this.closeWhenDone.get() && this.count.get() == 0;
                }
                if (shouldRunClose) {
                    closeEffect.close();
                }
                return result;
            }
        }
    }

    public static class AlreadyClosedException
    extends RuntimeIOException {
        private static final long serialVersionUID = 6294831692421064645L;

        AlreadyClosedException() {
            super(new IOException());
        }
    }
}

