/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.GenericSearchExtractorContext;
import com.atlassian.jira.issue.index.DocumentScrubber;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public interface EntityDocumentFactory<T>
extends Function<T, Option<Document>> {

    public static abstract class EntityDocumentBuilder<T, C extends EntityDocumentBuilder<T, C>> {
        protected final Document doc = new Document();
        private final GenericSearchExtractorContext<T> context;

        protected EntityDocumentBuilder(T entity, String indexName) {
            this.context = new GenericSearchExtractorContext<T>(entity, indexName);
        }

        public C addAllExtractors(Collection<EntitySearchExtractor<T>> extractors) {
            try (Ticker ignored = Metrics.startTimer((String)("indexing." + this.getDocumentType() + "AddSearchExtractors"));){
                for (EntitySearchExtractor<T> extractor : extractors) {
                    try {
                        Ticker ignored2 = Timers.start((String)(extractor.getClass().getSimpleName() + ".indexEntity()"));
                        Throwable throwable = null;
                        try {
                            this.fieldsAddedByExtractor(extractor.indexEntity(this.context, this.doc));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ignored2 == null) continue;
                            if (throwable != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ignored2.close();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    catch (LinkageError linkageError) {}
                }
                Iterator<Object> iterator = this.cast();
                return (C)iterator;
            }
        }

        public C addTokenizedField(String name, String value, Field.Store store) {
            this.doc.add((IndexableField)new TextField(name, value, store));
            return this.cast();
        }

        public C addSearchableField(String name, String value, Field.Store store) {
            this.doc.add((IndexableField)new StringField(name, value, store));
            return this.cast();
        }

        private C addSearchableField(String name, Long value, Field.Store store) {
            this.doc.add((IndexableField)new LongPoint(name, new long[]{value}));
            if (Field.Store.YES.equals((Object)store)) {
                this.doc.add((IndexableField)new StoredField(name, value.longValue()));
            }
            return this.cast();
        }

        public C addSearchableField(String name, Date date, Field.Store store) {
            if (date != null) {
                long timestamp = date.getTime();
                return this.addSearchableField(name, timestamp, store);
            }
            return this.cast();
        }

        public C addSearchableField(String name, LocalDate localDate, Field.Store store) {
            if (localDate != null) {
                long daysFromEpoch = localDate.getEpochDays();
                return this.addSearchableField(name, daysFromEpoch, store);
            }
            return this.cast();
        }

        public C addSortableField(String name, String value) {
            this.doc.add((IndexableField)new SortedDocValuesField(name, new BytesRef((CharSequence)value)));
            return this.cast();
        }

        private C addSortableField(String name, Long value) {
            this.doc.add((IndexableField)new NumericDocValuesField(name, value.longValue()));
            return this.cast();
        }

        public C addSortableField(String name, Date value) {
            if (value != null) {
                long timestamp = value.getTime();
                return this.addSortableField(name, timestamp);
            }
            return this.cast();
        }

        public C addKeywordWithDefault(String name, String value, String defaultValue) {
            FieldIndexerUtil.indexKeywordWithDefault((Document)this.doc, (String)name, (String)value, (String)defaultValue);
            return this.cast();
        }

        public C addKeywordWithDefault(String name, Long value, String defaultValue) {
            FieldIndexerUtil.indexKeywordWithDefault((Document)this.doc, (String)name, (Long)value, (String)defaultValue);
            return this.cast();
        }

        protected void fieldsAddedByExtractor(Set<String> fieldIds) {
        }

        protected abstract String getDocumentType();

        private C cast() {
            return (C)this;
        }

        public Option<Document> build() {
            new DocumentScrubber().accept(this.doc);
            return Option.some((Object)this.doc);
        }
    }
}

