/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.index.IndexCounterManager;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterNodeIndexCounterManager
extends IndexCounterManager {
    private final OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore;
    private final ClusterManager clusterManager;
    private final Map<String, Long> bufferedIndexCounters = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> preparedIndexCounters = new HashMap<String, Long>();

    public ClusterNodeIndexCounterManager(OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore, ClusterManager clusterManager) {
        this.ofBizNodeIndexCounterStore = ofBizNodeIndexCounterStore;
        this.clusterManager = clusterManager;
    }

    @Override
    public void storeHighestIdForNode(String sendingNodeId, long indexOperationId) {
        this.bufferedIndexCounters.put(sendingNodeId, indexOperationId);
    }

    @Override
    public long getIndexOperationCounterForNodeId(String sendingNodeId) {
        String currentNodeId = this.clusterManager.getNodeId();
        return Optional.ofNullable(this.bufferedIndexCounters.get(sendingNodeId)).orElseGet(() -> this.ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(currentNodeId, sendingNodeId));
    }

    @Override
    public void onBeforeCommit() {
        this.preparedIndexCounters.putAll(this.bufferedIndexCounters);
    }

    @Override
    public void onAfterCommit() {
        String currentNodeId = this.clusterManager.getNodeId();
        for (Map.Entry<String, Long> nodeOperation : this.preparedIndexCounters.entrySet()) {
            this.ofBizNodeIndexCounterStore.storeHighestIdForNode(currentNodeId, nodeOperation.getKey(), nodeOperation.getValue());
            this.bufferedIndexCounters.remove(nodeOperation.getKey(), nodeOperation.getValue());
        }
        this.preparedIndexCounters.clear();
    }
}

