/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.instrumentation.AtomicCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.index.ha.FailedReplicationOperation;
import com.atlassian.jira.index.ha.FailedReplicationOperationService;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.NodeIndexCounterStore;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.concurrent.ScheduledExecutorServiceUtils;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeReindexService
implements NodeReindexService {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeReindexService.class);
    private final ReIndexStatsLogger statsLogger = new ReIndexStatsLogger();
    private final ClusterManager clusterManager;
    private final NodeIndexCounterStore nodeIndexCounterStore;
    private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
    private final IssueIndexManager indexManager;
    private final SharedEntityIndexer sharedEntityIndexer;
    private final ProjectManager projectManager;
    private final ProjectReindexService projectReindexService;
    private final IssueManager issueManager;
    private final CommentManager commentManager;
    private final WorklogManager worklogManager;
    private final OfBizDelegator ofBizDelegator;
    private final SharedEntityResolver sharedEntityResolver;
    private final IndexCopyService indexCopyService;
    private final IssueIndexingService indexingService;
    private final IssueFactory issueFactory;
    private final FailedReplicationOperationService.FailedReplicationOperationContext failedReplicationOperationContext;
    public static final String ISSUE_ENTITY = "Issue";
    private final Runnable indexer = JiraThreadLocalUtils.wrap(this::reIndex);
    private final ScheduledExecutorService scheduler;
    private final LatestGaugeValue latestGaugeValue = new LatestGaugeValue();
    private final Counter totalOperationCountInstrument;
    @Nullable
    private ScheduledFuture<?> indexerService;
    private static final int INITIAL_DELAY_SEC = 10;
    private static final int PERIOD_SEC = 5;

    public DefaultNodeReindexService(ClusterManager clusterManager, NodeIndexCounterStore nodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager indexManager, SharedEntityIndexer sharedEntityIndexer, ProjectManager projectManager, ProjectReindexService projectReindexService, IssueManager issueManager, CommentManager commentManager, WorklogManager worklogManager, OfBizDelegator ofBizDelegator, SharedEntityResolver sharedEntityResolver, IndexCopyService indexCopyService, IssueIndexingService indexingService, IssueFactory issueFactory, FailedReplicationOperationService failedReplicationOperationService) {
        this.clusterManager = clusterManager;
        this.nodeIndexCounterStore = nodeIndexCounterStore;
        this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
        this.indexManager = indexManager;
        this.sharedEntityIndexer = sharedEntityIndexer;
        this.projectManager = projectManager;
        this.projectReindexService = projectReindexService;
        this.issueManager = issueManager;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.ofBizDelegator = ofBizDelegator;
        this.sharedEntityResolver = sharedEntityResolver;
        this.indexCopyService = indexCopyService;
        this.indexingService = indexingService;
        this.issueFactory = issueFactory;
        this.failedReplicationOperationContext = failedReplicationOperationService.getContext();
        this.scheduler = Executors.newScheduledThreadPool(1, ThreadFactories.namedThreadFactory("NodeReindexServiceThread"));
        this.totalOperationCountInstrument = new AtomicCounter(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_TOTAL.getInstrumentName());
        ExternalGauge operationCountInstrument = new ExternalGauge(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_LATEST.getInstrumentName(), (ExternalValue)this.latestGaugeValue);
        Instrumentation.putInstrument((Instrument)this.totalOperationCountInstrument);
        Instrumentation.putInstrument((Instrument)operationCountInstrument);
    }

    @Override
    public void cancel() {
        this.pause();
        this.scheduler.shutdownNow();
    }

    @Override
    public synchronized void start() {
        log.info("Starting node re-index service");
        if (this.indexerService == null && this.clusterManager.isClustered()) {
            this.indexerService = ScheduledExecutorServiceUtils.scheduleWithVariableDelay(this.scheduler, this.indexer, Duration.ofSeconds(10L), Duration.ofSeconds(5L));
        } else if (log.isDebugEnabled()) {
            log.debug("Start called on NodeReindexService when already running", (Throwable)new IllegalStateException());
        }
    }

    @Override
    public synchronized void pause() {
        log.info("Pausing node re-index service");
        if (this.indexerService != null) {
            this.indexerService.cancel(true);
            this.indexerService = null;
        }
    }

    @Override
    public void restart() {
        this.pause();
        this.start();
    }

    @Override
    public void resetIndexCount() {
        for (Node node : this.clusterManager.getAllNodes()) {
            Long lastId = this.ofBizNodeIndexOperationStore.getLatestOperation(node.getNodeId());
            if (lastId == null) continue;
            this.nodeIndexCounterStore.storeHighestIdForNode(node.getNodeId(), lastId);
        }
    }

    @Override
    public boolean canIndexBeRebuilt() {
        String currentNodeId = this.getCurrentNodeId();
        for (Node node : this.clusterManager.getAllNodes()) {
            Long latestOperation;
            long lastIndexed;
            String nodeId = node.getNodeId();
            if (!node.isClustered() || nodeId == null || nodeId.equals(currentNodeId) || this.ofBizNodeIndexOperationStore.contains(lastIndexed = this.getCurrentIndexCount(nodeId)) || (latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(nodeId)) == null) continue;
            return false;
        }
        return this.indexManager.isIndexConsistent();
    }

    @Override
    public Future<Long> replayLocalOperations() {
        return this.scheduler.submit(JiraThreadLocalUtils.wrap(() -> {
            String result;
            Stopwatch stopwatch = Stopwatch.createStarted();
            long numberOfOperations = 0L;
            boolean error = false;
            try {
                String currentNodeId = this.getCurrentNodeId();
                log.info("Starting replayLocalOperations for the node, nodeId={}", (Object)currentNodeId);
                Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfter(currentNodeId, this.getCurrentIndexCount(currentNodeId));
                numberOfOperations = indexOps.size();
                this.applyIndexOperations(indexOps);
                result = error ? "Success" : "Failure";
            }
            catch (Throwable t) {
                String result2;
                try {
                    error = true;
                    log.error("Error re-indexing node changes", t);
                    result2 = error ? "Success" : "Failure";
                }
                catch (Throwable throwable) {
                    String result3 = error ? "Success" : "Failure";
                    log.info("Finished replayLocalOperations for the node, result={}, nodeId={}, numberOfOperations={}, took={}.", new Object[]{result3, this.getCurrentNodeId(), numberOfOperations, stopwatch});
                    throw throwable;
                }
                log.info("Finished replayLocalOperations for the node, result={}, nodeId={}, numberOfOperations={}, took={}.", new Object[]{result2, this.getCurrentNodeId(), numberOfOperations, stopwatch});
            }
            log.info("Finished replayLocalOperations for the node, result={}, nodeId={}, numberOfOperations={}, took={}.", new Object[]{result, this.getCurrentNodeId(), numberOfOperations, stopwatch});
            return numberOfOperations;
        }));
    }

    @Nullable
    @VisibleForTesting
    ScheduledFuture<?> getIndexerService() {
        return this.indexerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reIndex() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String currentNodeId = this.getCurrentNodeId();
        log.debug("Starting reIndex for the node, nodeId={}", (Object)currentNodeId);
        if (currentNodeId == null) {
            log.debug("Finished reIndex for the node as nodeId=null, took={}.", (Object)stopwatch);
            return;
        }
        boolean error = false;
        int numberOfOperations = 0;
        try {
            HashSet allIndexOps = Sets.newHashSet();
            Set<Node> allNodes = this.clusterManager.getAllNodes();
            for (Node sourceNodeId : allNodes) {
                if (currentNodeId.equals(sourceNodeId.getNodeId())) continue;
                Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfter(sourceNodeId.getNodeId(), this.getCurrentIndexCount(sourceNodeId.getNodeId()));
                allIndexOps.addAll(indexOps);
                log.debug("Index operations stats: operationsCount={}, sourceNodeId={}, nodeId={}", new Object[]{allIndexOps.size(), sourceNodeId.getNodeId(), currentNodeId});
            }
            this.applyIndexOperations(allIndexOps);
            numberOfOperations = allIndexOps.size();
            this.totalOperationCountInstrument.addAndGet((long)numberOfOperations);
            this.latestGaugeValue.setValue(numberOfOperations);
            this.retryPreviouslyFailedOperations();
        }
        catch (Throwable e) {
            log.error("Error re-indexing node changes", e);
            error = true;
        }
        finally {
            log.debug("Finished reIndex for the node, nodeId={}, took={}.", (Object)currentNodeId, (Object)stopwatch);
        }
        stopwatch.stop();
        this.statsLogger.log(currentNodeId, numberOfOperations, stopwatch.elapsed(TimeUnit.MILLISECONDS), error);
    }

    private void applyIndexOperations(Set<ReplicatedIndexOperation> indexOperations) {
        if (!indexOperations.isEmpty()) {
            log.debug("Applying index operations: current node={}, numberOfIndexOperations={}", (Object)this.getCurrentNodeId(), (Object)indexOperations.size());
            try {
                this.updateAffectedIndexes(indexOperations);
            }
            catch (Exception e) {
                this.failedReplicationOperationContext.addOperation(indexOperations);
                throw new RuntimeException("Failed to update index for (" + indexOperations + ")", e);
            }
            finally {
                this.updateIndexCount(indexOperations);
            }
        }
    }

    private void retryPreviouslyFailedOperations() {
        for (FailedReplicationOperation operation : this.failedReplicationOperationContext.getOperationsToRetry()) {
            log.info("Retrying indexing of {}", (Object)operation);
            try {
                this.updateAffectedIndexes(operation.getOperations());
                log.info("Successfully retried indexing of {}", (Object)operation);
            }
            catch (Exception e) {
                log.error(String.format("Failed re-attempting to replicate index operations for (%s)", operation), (Throwable)e);
                this.failedReplicationOperationContext.addOperation(operation);
            }
        }
    }

    private void updateIndexCount(Set<ReplicatedIndexOperation> indexOps) {
        Map<String, Long> highestNodeCounts = this.getHighestNodeCounts(indexOps);
        for (Map.Entry<String, Long> countEntry : highestNodeCounts.entrySet()) {
            this.nodeIndexCounterStore.storeHighestIdForNode(countEntry.getKey(), countEntry.getValue());
        }
    }

    private String getCurrentNodeId() {
        return this.clusterManager.getNodeId();
    }

    private long getCurrentIndexCount(String sendingNodeId) {
        return this.nodeIndexCounterStore.getIndexOperationCounterForNodeId(sendingNodeId);
    }

    private void updateAffectedIndexes(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        ReplicatedIndexOperation latestReindex = null;
        for (ReplicatedIndexOperation indexOp : indexOps) {
            log.trace("Index operation to replay={},  operation.reindexEnd={}, entityType={}, indexTime={}", new Object[]{indexOp.getOperation(), indexOp.getOperation().isReindexEnd(), indexOp.getEntityType(), indexOp.getIndexTime()});
            if (!indexOp.getOperation().isReindexEnd() || latestReindex != null && indexOp.getIndexTime().getTime() <= latestReindex.getIndexTime().getTime()) continue;
            latestReindex = indexOp;
        }
        if (latestReindex != null) {
            log.info("Re-index after last sync detected: operationName={}, sourceNodeId={}, indexTime={}. Resetting index count and restoring index from backupFilename='{}'", new Object[]{latestReindex.getOperation(), latestReindex.getNodeId(), latestReindex.getIndexTime(), latestReindex.getBackupFilename()});
            this.resetIndexCount();
            this.indexCopyService.restoreIndex(latestReindex.getBackupFilename());
            return;
        }
        Map<AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations = this.partition(indexOps);
        log.debug("Updating indexes with new data: issueSize={}, commentSize={}, sharedEntitySize={}, worklogSize={}", new Object[]{partitionedOperations.get(AffectedIndex.ISSUE).size(), partitionedOperations.get(AffectedIndex.COMMENT).size(), partitionedOperations.get(AffectedIndex.SHAREDENTITY).size(), partitionedOperations.get(AffectedIndex.WORKLOG).size()});
        this.updateIssueIndex(partitionedOperations.get(AffectedIndex.ISSUE));
        this.updateCommentsIndex(partitionedOperations.get(AffectedIndex.COMMENT));
        this.updateSharedEntityIndex(partitionedOperations.get(AffectedIndex.SHAREDENTITY));
        this.updateWorklogsIndex(partitionedOperations.get(AffectedIndex.WORKLOG));
    }

    private void updateSharedEntityIndex(Set<ReplicatedIndexOperation> indexOps) {
        HashSet entitiesToIndex = Sets.newHashSet();
        HashSet entitiesToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    entitiesToIndex.addAll(this.sharedEntityResolver.getSharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    entitiesToDelete.addAll(this.sharedEntityResolver.getDummySharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                }
            }
        }
        if (!entitiesToIndex.isEmpty()) {
            this.sharedEntityIndexer.index(entitiesToIndex, false).await();
        }
        if (!entitiesToDelete.isEmpty()) {
            this.sharedEntityIndexer.deIndex(entitiesToDelete, false).await();
        }
        long endTime = System.currentTimeMillis();
        indexOps.forEach(op -> IndexingTimers.REPLICATION_LATENCY.update(endTime - op.getIndexTime().getTime(), TimeUnit.MILLISECONDS));
    }

    private void updateCommentsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet commentsToIndex = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Long id : operation.getAffectedIds()) {
                Comment comment = this.commentManager.getCommentById(id);
                if (comment == null) continue;
                commentsToIndex.add(comment);
            }
        }
        if (!commentsToIndex.isEmpty()) {
            this.indexingService.reIndexComments((Collection)commentsToIndex, Contexts.nullContext(), false);
            long endTime = System.currentTimeMillis();
            indexOps.forEach(op -> IndexingTimers.REPLICATION_LATENCY.update(endTime - op.getIndexTime().getTime(), TimeUnit.MILLISECONDS));
        }
    }

    private void updateWorklogsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet worklogsToIndex = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Long id : operation.getAffectedIds()) {
                Worklog worklog = this.worklogManager.getById(id);
                if (worklog == null) continue;
                worklogsToIndex.add(worklog);
            }
        }
        if (!worklogsToIndex.isEmpty()) {
            this.indexingService.reIndexWorklogs((Collection)worklogsToIndex, Contexts.nullContext(), false);
            long endTime = System.currentTimeMillis();
            indexOps.forEach(op -> IndexingTimers.REPLICATION_LATENCY.update(endTime - op.getIndexTime().getTime(), TimeUnit.MILLISECONDS));
        }
    }

    private void updateIssueIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet projectsToUpdate = Sets.newHashSet();
        HashSet projectToDeIndex = Sets.newHashSet();
        HashSet issuesToUpdate = Sets.newHashSet();
        HashSet issuesAndRelatedIndexesToUpdate = Sets.newHashSet();
        TreeSet issuesToDelete = Sets.newTreeSet(Comparator.comparing(Issue::getId));
        block14: for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    issuesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case UPDATE_WITH_RELATED: {
                    issuesAndRelatedIndexesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    for (long id : operation.getAffectedIds()) {
                        GenericValue gv = this.ofBizDelegator.makeValue(ISSUE_ENTITY, (Map)ImmutableMap.of((Object)"id", (Object)id));
                        issuesToDelete.add(this.issueFactory.getIssue(gv));
                    }
                    continue block14;
                }
                case PROJECT_REINDEX: {
                    Project project;
                    for (long id : operation.getAffectedIds()) {
                        project = this.projectManager.getProjectObj(Long.valueOf(id));
                        if (project == null) continue;
                        projectsToUpdate.add(project);
                    }
                    continue block14;
                }
                case PROJECT_DEINDEX: {
                    Project project;
                    for (long id : operation.getAffectedIds()) {
                        project = this.projectManager.getProjectObj(Long.valueOf(id));
                        if (project == null) continue;
                        projectToDeIndex.add(project);
                    }
                    break;
                }
            }
        }
        issuesToUpdate.removeAll(issuesAndRelatedIndexesToUpdate);
        if (!issuesToUpdate.isEmpty()) {
            this.indexingService.reIndexIssueObjects((Collection)issuesToUpdate, IssueIndexingParams.builder().withChangeHistory().build(), false);
        }
        long issuesToUpdateTimestamp = System.currentTimeMillis();
        if (!issuesAndRelatedIndexesToUpdate.isEmpty()) {
            this.indexingService.reIndexIssueObjects((Collection)issuesAndRelatedIndexesToUpdate, IssueIndexingParams.INDEX_ALL, false);
        }
        long issuesAndRelatedIndexesToUpdateTimestamp = System.currentTimeMillis();
        if (!issuesToDelete.isEmpty()) {
            this.indexingService.deIndexIssueObjects((Set)issuesToDelete, false);
        }
        long issuesToDeleteTimestamp = System.currentTimeMillis();
        projectsToUpdate.forEach(this::reindexProject);
        long projectsToUpdateTimestamp = System.currentTimeMillis();
        projectToDeIndex.forEach(this::deindexProject);
        long projectsToDeIndexTimestamp = System.currentTimeMillis();
        block18: for (ReplicatedIndexOperation operation : indexOps) {
            long end;
            switch (operation.getOperation()) {
                case UPDATE: 
                case CREATE: {
                    end = issuesToUpdateTimestamp;
                    break;
                }
                case UPDATE_WITH_RELATED: {
                    end = issuesAndRelatedIndexesToUpdateTimestamp;
                    break;
                }
                case DELETE: {
                    end = issuesToDeleteTimestamp;
                    break;
                }
                case PROJECT_REINDEX: {
                    end = projectsToUpdateTimestamp;
                    break;
                }
                case PROJECT_DEINDEX: {
                    end = projectsToDeIndexTimestamp;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            IndexingTimers.REPLICATION_LATENCY.update(end - operation.getIndexTime().getTime(), TimeUnit.MILLISECONDS);
        }
    }

    private void deindexProject(Project project) {
        this.indexingService.deIndex(project, false);
    }

    private void reindexProject(Project project) {
        try {
            if (this.projectReindexService.isReindexPossible(project)) {
                this.projectReindexService.reindex(project, false);
            }
        }
        catch (AlreadyExecutingException aee) {
            log.debug("Lost race detecting that project reindex for '" + project.getKey() + "' is already in progress", (Throwable)aee);
        }
    }

    private Map<AffectedIndex, Set<ReplicatedIndexOperation>> partition(Set<ReplicatedIndexOperation> indexOps) {
        HashMap partitionedOperations = Maps.newHashMap();
        for (AffectedIndex affectedIndex : AffectedIndex.values()) {
            partitionedOperations.put(affectedIndex, Sets.newHashSet());
        }
        for (ReplicatedIndexOperation operation : indexOps) {
            ((Set)partitionedOperations.get(operation.getAffectedIndex())).add(operation);
        }
        return partitionedOperations;
    }

    private Map<String, Long> getHighestNodeCounts(Iterable<ReplicatedIndexOperation> indexOperations) {
        HashMap<String, Long> highestOperationIds = new HashMap<String, Long>();
        for (ReplicatedIndexOperation indexOperation : indexOperations) {
            String nodeId = indexOperation.getNodeId();
            Long currentHigh = (Long)highestOperationIds.get(nodeId);
            if (currentHigh != null && currentHigh >= indexOperation.getId()) continue;
            highestOperationIds.put(nodeId, indexOperation.getId());
        }
        return highestOperationIds;
    }

    private static class LatestGaugeValue
    implements ExternalValue {
        private long value = 0L;

        private LatestGaugeValue() {
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    private class ReIndexStatsLogger {
        private final long minLogFrequencyInSeconds = TimeUnit.MINUTES.toSeconds(5L);
        private final Stopwatch lastLogTime;
        private final AtomicInteger sumNumberOfOperations = new AtomicInteger(0);
        private final AtomicLong sumTimeInMillis = new AtomicLong(0L);
        private final AtomicInteger sumErrors = new AtomicInteger(0);

        ReIndexStatsLogger() {
            this.lastLogTime = Stopwatch.createStarted();
        }

        void log(String nodeId, int numberOfOperations, long timeInMillis, boolean error) {
            this.sumNumberOfOperations.addAndGet(numberOfOperations);
            this.sumTimeInMillis.addAndGet(timeInMillis);
            this.sumErrors.addAndGet(error ? 1 : 0);
            if (this.lastLogTime.elapsed(TimeUnit.SECONDS) > this.minLogFrequencyInSeconds) {
                log.info("Node replay index operations stats: nodeId={}, numberOfOperations={}, timeToReplay={}ms, errors={}, period={}", new Object[]{nodeId, this.sumNumberOfOperations.get(), this.sumTimeInMillis.get(), this.sumErrors.get(), this.lastLogTime});
                this.sumNumberOfOperations.set(0);
                this.sumTimeInMillis.set(0L);
                this.sumErrors.set(0);
                this.lastLogTime.reset().start();
            }
        }
    }
}

