/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.util.PathUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSnapshotService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSnapshotService.class);
    protected static final String SERVICE_NAME = "JIRA Index Snapshot Service";
    public static final String BACKUP_COUNT = "backupCount";
    public static final int DEFAULT_COUNT = 3;
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MMM-dd--HHmm";
    public static final String SERVICE_KEY = "indexsnapshotservice";
    private final IndexPathManager indexPathManager;
    private final JiraHome jiraHome;
    private final IndexUtils indexUtils;
    private int backupCount = 3;

    public IndexSnapshotService(IndexPathManager indexPathManager, JiraHome jiraHome, IndexUtils indexUtils) {
        this.indexPathManager = indexPathManager;
        this.jiraHome = jiraHome;
        this.indexUtils = indexUtils;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(BACKUP_COUNT)) {
            String count = this.getProperty(BACKUP_COUNT);
            try {
                this.backupCount = Integer.parseInt(count);
                if (this.backupCount < 1) {
                    this.backupCount = 3;
                    LOG.warn("Invalid Index backup count specified in service configuration; defaulting to 3.");
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid Index backup count specified in service configuration; defaulting to 3.", (Throwable)e);
            }
        }
    }

    public String getKey() {
        return SERVICE_KEY;
    }

    public boolean isUnique() {
        return true;
    }

    public boolean isInternal() {
        return true;
    }

    public void run() {
        String destinationPath = PathUtils.joinPaths((String[])new String[]{this.jiraHome.getExportDirectory().getAbsolutePath(), "indexsnapshots"});
        String id = new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(new Date());
        this.indexUtils.performBackupOperations(destinationPath, id, this.backupCount, null, null);
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration(SERVICE_KEY, "services/com/atlassian/jira/service/services/index/indexsnapshotservice.xml", null);
    }

    public static String getServiceName() {
        return SERVICE_NAME;
    }
}

