/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskDescriptorHelper {
    private final TaskManager taskManager;

    public TaskDescriptorHelper(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Nullable
    public TaskDescriptor<IndexCommandResult> getActiveIndexTask() {
        return this.taskManager.getLiveTask(new IndexTaskContext());
    }

    @Nullable
    public TaskDescriptor<IndexCommandResult> getActiveForegroundIndexTask() {
        return this.taskManager.getLiveTask(new ForegroundIndexTaskContext());
    }

    public void waitForTaskCompletion(@Nonnull TaskDescriptor<IndexCommandResult> task) throws InterruptedException, ExecutionException {
        this.taskManager.waitUntilTaskCompletes(task.getTaskId());
    }
}

