/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.dropwizard.DropwizardMetricStrategy;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DropwizardMetrics
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(DropwizardMetrics.class);
    private final MetricRegistry metricRegistry;
    private final JmxMetricsExposer jmxMetricsExposer;
    private final JmxReporter jmxReporter;
    private final Object jmxExposeLock = new Object();

    public DropwizardMetrics(JmxMetricsExposer jmxMetricsExposer) {
        this.jmxMetricsExposer = jmxMetricsExposer;
        this.metricRegistry = new MetricRegistry();
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain("com.atlassian.jira").createsObjectNamesWith((ObjectNameFactory)new GroupingObjectNameFactory()).build();
        StrategiesRegistry.addMetricStrategy((MetricStrategy)new DropwizardMetricStrategy(this.metricRegistry));
    }

    public void start() throws Exception {
        this.setEnabled(this.jmxMetricsExposer.isJmxEnabled());
    }

    @EventListener
    public void onJmxMetricsEvent(JmxConfigurationChangedEvent event) {
        this.setEnabled(event.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(boolean jmxEnabled) {
        Object object = this.jmxExposeLock;
        synchronized (object) {
            Metrics.getConfiguration().setEnabled(jmxEnabled);
            if (jmxEnabled) {
                this.jmxReporter.start();
                log.debug("Started exposing dropwizard metrics");
            } else {
                this.jmxReporter.stop();
                log.debug("Stopped exposing dropwizard metrics");
            }
        }
    }

    private static class GroupingObjectNameFactory
    implements ObjectNameFactory {
        private static final Logger log = LoggerFactory.getLogger(GroupingObjectNameFactory.class);

        private GroupingObjectNameFactory() {
        }

        public ObjectName createName(String type, String domain, String name) {
            StringBuilder builder = new StringBuilder(domain).append(":type=metrics,");
            String[] parts = name.split("\\.");
            for (int i = 0; i < parts.length - 1; ++i) {
                builder.append("category").append(StringUtils.leftPad((String)Integer.toString(i), (int)2, (char)'0')).append("=").append(parts[i]).append(',');
            }
            builder.append("name=").append(parts[parts.length - 1]);
            try {
                return new ObjectName(builder.toString());
            }
            catch (MalformedObjectNameException e) {
                log.warn("Unable to register {} {}", new Object[]{type, name, e});
                throw new RuntimeException(e);
            }
        }
    }
}

