/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RequestData {
    private final Optional<String> path;
    private final Optional<String> traceId;
    private final Optional<String> spanId;
    private final Optional<String> parentSpanId;
    private final Optional<String> queryString;
    private final Optional<Long> startNanoTime;

    private RequestData(Optional<String> path, Optional<String> traceId, Optional<String> spanId, Optional<String> parentSpanId, Optional<String> queryString, Optional<Long> startNanoTime) {
        this.path = path;
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.queryString = queryString;
        this.startNanoTime = startNanoTime;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<String> getTraceId() {
        return this.traceId;
    }

    public Optional<String> getSpanId() {
        return this.spanId;
    }

    public Optional<String> getParentSpanId() {
        return this.parentSpanId;
    }

    public Optional<String> getQueryString() {
        return this.queryString;
    }

    public Optional<Long> getStartNanoTime() {
        return this.startNanoTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestData that = (RequestData)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.traceId, that.traceId) && Objects.equals(this.spanId, that.spanId) && Objects.equals(this.parentSpanId, that.parentSpanId) && Objects.equals(this.queryString, that.queryString) && Objects.equals(this.startNanoTime, that.startNanoTime);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.traceId, this.spanId, this.parentSpanId, this.queryString);
    }

    public static class Builder {
        private Optional<String> path = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        private Optional<String> spanId = Optional.empty();
        private Optional<String> parentSpanId = Optional.empty();
        private Optional<String> queryString = Optional.empty();
        private Optional<Long> startNanoTime = Optional.empty();

        public Builder setPath(@Nullable String path) {
            this.path = Optional.ofNullable(Objects.requireNonNull(path));
            return this;
        }

        public Builder setPath(Optional<String> path) {
            this.path = path;
            return this;
        }

        public Builder setTraceId(@Nullable String traceId) {
            this.traceId = Optional.ofNullable(Objects.requireNonNull(traceId));
            return this;
        }

        public Builder setTraceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder setSpanId(@Nullable String spanId) {
            this.spanId = Optional.ofNullable(spanId);
            return this;
        }

        public Builder setParentSpanId(@Nullable String parentSpanId) {
            this.parentSpanId = Optional.ofNullable(parentSpanId);
            return this;
        }

        public Builder setQueryString(@Nullable String queryString) {
            this.queryString = Optional.ofNullable(queryString);
            return this;
        }

        public Builder setStartNanoTime(@Nullable Long startNanoTime) {
            this.startNanoTime = Optional.ofNullable(startNanoTime);
            return this;
        }

        public RequestData build() {
            return new RequestData(this.path, this.traceId, this.spanId, this.parentSpanId, this.queryString, this.startNanoTime);
        }
    }
}

