/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AbstractIssue;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueImpl
extends AbstractIssue
implements MutableIssue {
    private final ProjectManager projectManager;
    private final ArchivedProjectManager archivedProjectManager;
    private final VersionManager versionManager;
    private final LabelManager labelManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SubTaskManager subTaskManager;
    private final ProjectComponentManager projectComponentManager;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private GenericValue genericValue;
    private Long projectId;
    private Long issueNumber;
    private String key;
    private String issueTypeId;
    private String summary;
    private String description;
    private String environment;
    private String assigneeId;
    private String reporterId;
    private Timestamp created;
    private Timestamp updated;
    private Timestamp dueDate;
    private Timestamp resolutionDate;
    private Long securityLevelId;
    private String priorityId;
    private String resolutionId;
    private String statusId;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long estimate;
    private Long timespent;
    private Long workflowId;
    private Set<Label> labels;
    private String creatorId;
    private IssueType issueType;
    private ApplicationUser assignee;
    private ApplicationUser reporter;
    private ApplicationUser creator;
    private Collection<ProjectComponent> components;
    private Collection<Version> affectedVersions;
    private Collection<Version> fixVersions;
    private GenericValue securityLevel;
    private Priority priority;
    private Resolution resolution;
    private Status status;
    private boolean archived;
    private String archivedByUserId;
    private ApplicationUser archivedByUser;
    private Timestamp archivedDate;
    private final Map<CustomField, Object> customFieldValues;
    private final Map<String, ModifiedValue> modifiedFields;
    private final Map<String, Object> externalFields;
    private Long parentId;
    boolean hasNoParentId = false;
    private Issue parentIssue;
    private final ResettableLazyReference<Issue> parentIssueLazyReference;
    private final ResettableLazyReference<Collection<Issue>> subTasksLazyReference;

    public IssueImpl(GenericValue genericValue, final IssueManager issueManager, ProjectManager projectManager, ArchivedProjectManager archivedProjectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, final SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext, ArchivingLicenseCheck archivingLicenseCheck) {
        super(constantsManager, issueManager, attachmentManager);
        this.genericValue = genericValue;
        this.projectManager = projectManager;
        this.archivedProjectManager = archivedProjectManager;
        this.versionManager = versionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.subTaskManager = subTaskManager;
        this.labelManager = labelManager;
        this.projectComponentManager = projectComponentManager;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldValues = new HashMap<CustomField, Object>();
        this.modifiedFields = new HashMap<String, ModifiedValue>();
        this.externalFields = new HashMap<String, Object>();
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.parentIssueLazyReference = new ResettableLazyReference<Issue>(){

            protected Issue create() throws Exception {
                if (IssueImpl.this.isSubTask()) {
                    return issueManager.getIssueObject(IssueImpl.this.getParentId());
                }
                return null;
            }
        };
        this.subTasksLazyReference = new ResettableLazyReference<Collection<Issue>>(){

            protected Collection<Issue> create() throws Exception {
                return subTaskManager.getSubTaskObjects((Issue)IssueImpl.this);
            }
        };
        this.copyValuesFromGV(genericValue);
        this.initializeKey();
    }

    public IssueImpl(@Nonnull Issue issue, IssueManager issueManager, ProjectManager projectManager, ArchivedProjectManager archivedProjectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext, ArchivingLicenseCheck archivingLicenseCheck) {
        this((GenericValue)null, issueManager, projectManager, archivedProjectManager, versionManager, issueSecurityLevelManager, constantsManager, subTaskManager, attachmentManager, labelManager, projectComponentManager, userManager, jiraAuthenticationContext, archivingLicenseCheck);
        Preconditions.checkNotNull((Object)issue);
        this.setAffectedVersions(issue.getAffectedVersions());
        this.setFixVersions(issue.getFixVersions());
        this.setComponent(issue.getComponentObjects());
        this.setLabels(issue.getLabels());
        if (issue.getGenericValue() != null) {
            this.copyValuesFromGV(issue.getGenericValue());
        } else {
            this.copyValuesFromIssue(issue);
        }
        this.setParentId(issue.getParentId());
        this.initializeKey();
    }

    public static MutableIssue getIssueObject(GenericValue genericValue) {
        return new IssueImpl(genericValue, ComponentAccessor.getIssueManager(), ComponentAccessor.getProjectManager(), (ArchivedProjectManager)ComponentAccessor.getComponentOfType(ArchivedProjectManager.class), ComponentAccessor.getVersionManager(), ComponentAccessor.getIssueSecurityLevelManager(), ComponentAccessor.getConstantsManager(), ComponentAccessor.getSubTaskManager(), ComponentAccessor.getAttachmentManager(), (LabelManager)ComponentAccessor.getComponentOfType(LabelManager.class), (ProjectComponentManager)ComponentAccessor.getComponentOfType(ProjectComponentManager.class), (UserManager)ComponentAccessor.getComponentOfType(UserManager.class), (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class), (ArchivingLicenseCheck)ComponentAccessor.getComponentOfType(ArchivingLicenseCheck.class));
    }

    private void copyValuesFromGV(GenericValue genericValue) {
        if (genericValue != null) {
            this.projectId = genericValue.getLong("project");
            this.issueNumber = genericValue.getLong("number");
            this.issueTypeId = genericValue.getString("type");
            this.summary = genericValue.getString("summary");
            this.description = genericValue.getString("description");
            this.environment = genericValue.getString("environment");
            this.assigneeId = genericValue.getString("assignee");
            this.reporterId = genericValue.getString("reporter");
            this.creatorId = genericValue.getString("creator");
            this.dueDate = genericValue.getTimestamp("duedate");
            this.securityLevelId = genericValue.getLong("security");
            this.priorityId = genericValue.getString("priority");
            this.statusId = genericValue.getString("status");
            this.resolutionId = genericValue.getString("resolution");
            this.created = genericValue.getTimestamp("created");
            this.updated = genericValue.getTimestamp("updated");
            this.resolutionDate = genericValue.getTimestamp("resolutiondate");
            this.originalEstimate = genericValue.getLong("timeoriginalestimate");
            this.estimate = genericValue.getLong("timeestimate");
            this.timespent = genericValue.getLong("timespent");
            this.votes = this.returnZeroIfNull(genericValue.getLong("votes"));
            this.watches = genericValue.getLong("watches");
            this.archived = Boolean.TRUE.equals(genericValue.getBoolean("archived"));
            this.archivedByUserId = genericValue.getString("archivedby");
            this.archivedDate = genericValue.getTimestamp("archiveddate");
            this.workflowId = genericValue.getLong("workflowId");
        }
    }

    private void copyValuesFromIssue(@Nonnull Issue issue) {
        this.projectId = issue.getProjectId();
        this.issueNumber = issue.getNumber();
        this.issueTypeId = issue.getIssueTypeId();
        this.summary = issue.getSummary();
        this.description = issue.getDescription();
        this.environment = issue.getEnvironment();
        this.assigneeId = issue.getAssigneeId();
        this.reporterId = issue.getReporterId();
        this.creatorId = issue.getCreatorId();
        this.dueDate = this.copyTimestampOrNullIfUnset(issue.getDueDate());
        this.securityLevelId = issue.getSecurityLevelId();
        Priority priorityObject = issue.getPriorityObject();
        this.priorityId = priorityObject != null ? priorityObject.getId() : null;
        Status statusObject = issue.getStatusObject();
        this.statusId = statusObject != null ? statusObject.getId() : null;
        this.resolutionId = issue.getResolutionId();
        this.created = this.copyTimestampOrNullIfUnset(issue.getCreated());
        this.updated = this.copyTimestampOrNullIfUnset(issue.getUpdated());
        this.resolutionDate = this.copyTimestampOrNullIfUnset(issue.getResolutionDate());
        this.originalEstimate = issue.getOriginalEstimate();
        this.estimate = issue.getEstimate();
        this.timespent = issue.getTimeSpent();
        this.votes = this.returnZeroIfNull(issue.getVotes());
        this.watches = issue.getWatches();
        this.archived = issue.isArchived();
        this.archivedByUserId = issue.getArchivedById();
        this.archivedDate = issue.getArchivedDate();
        this.workflowId = issue.getWorkflowId();
    }

    private Timestamp copyTimestampOrNullIfUnset(Timestamp timestamp) {
        return timestamp != null ? new Timestamp(timestamp.getTime()) : null;
    }

    private Long returnZeroIfNull(Long _votes) {
        return _votes == null ? new Long(0L) : _votes;
    }

    public Long getId() {
        return this.genericValue == null ? null : this.genericValue.getLong("id");
    }

    public GenericValue getProject() {
        Project project = null;
        if (this.projectId != null) {
            project = this.projectManager.getProjectObj(this.projectId);
        }
        return project != null ? project.getGenericValue() : null;
    }

    public Project getProjectObject() {
        return this.projectId == null ? null : this.projectManager.getProjectObj(this.projectId);
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        if (projectId == null) {
            this.setProjectObject(null);
        } else {
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                throw new IllegalArgumentException("Invalid Project ID '" + projectId + "'.");
            }
            this.setProjectObject(project);
        }
    }

    public void setProject(GenericValue project) {
        if (project == null) {
            this.setProjectObject(null);
        } else {
            this.setProjectId(project.getLong("id"));
        }
    }

    public void setProjectObject(Project project) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getProjectObject(), (Object)project);
        this.modifiedFields.put("project", modifiedValue);
        this.projectId = project != null ? project.getId() : null;
        if (this.genericValue != null) {
            this.genericValue.set("project", (Object)this.projectId);
        }
        this.initializeKey();
    }

    public IssueType getIssueType() {
        if (this.issueType == null && this.issueTypeId != null) {
            this.issueType = this.constantsManager.getIssueType(this.issueTypeId);
        }
        return this.issueType;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueType(IssueType issueType) {
        IssueType oldValue = this.getIssueType();
        this.issueType = issueType != null ? this.constantsManager.getIssueType(issueType.getId()) : null;
        this.modifiedFields.put("issuetype", new ModifiedValue((Object)oldValue, (Object)this.issueType));
        this.issueTypeId = issueType != null ? issueType.getId() : null;
        this.updateGV("type", this.issueTypeId);
    }

    public void setIssueTypeObject(IssueType issueType) {
        this.setIssueType(issueType);
    }

    public void setIssueTypeId(String issueTypeId) {
        if (issueTypeId != null) {
            this.setIssueTypeObject(this.constantsManager.getIssueType(issueTypeId));
        } else {
            this.setIssueType(null);
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getSummary(), (Object)summary);
        this.summary = summary;
        this.updateGV("summary", summary);
        this.modifiedFields.put("summary", modifiedValue);
    }

    public boolean isArchived() {
        return this.archivingLicenseCheck.isLicensedForIssueArchiving() && (this.archived || this.archivedProjectManager.isProjectArchived(this.getProjectObject()));
    }

    public void setArchived(boolean archived) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.isArchived(), (Object)archived);
        this.archived = archived;
        this.updateGV("archived", modifiedValue);
        this.modifiedFields.put("archived", modifiedValue);
    }

    public String getArchivedById() {
        return this.archivedByUserId;
    }

    public ApplicationUser getArchivedByUser() {
        if (this.archivedByUser == null && this.archivedByUserId != null) {
            this.archivedByUser = this.getUserByKey(this.archivedByUserId);
        }
        return this.archivedByUser;
    }

    public Timestamp getArchivedDate() {
        return this.archivedDate;
    }

    public ApplicationUser getReporterUser() {
        return this.getReporter();
    }

    public ApplicationUser getReporter() {
        if (this.reporter == null && this.reporterId != null) {
            this.reporter = this.getUserByKey(this.reporterId);
        }
        return this.reporter;
    }

    public String getReporterId() {
        return this.reporterId;
    }

    public ApplicationUser getCreator() {
        if (this.creator == null && this.creatorId != null) {
            this.creator = this.getUserByKey(this.creatorId);
        }
        return this.creator;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setReporter(ApplicationUser reporter) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getReporter(), (Object)reporter);
        this.reporter = reporter;
        this.modifiedFields.put("reporter", modifiedValue);
        this.reporterId = reporter != null ? ApplicationUsers.getKeyFor(reporter) : null;
        this.updateGV("reporter", this.reporterId);
    }

    public void setReporterId(String reporterId) {
        this.setReporter(this.getUserByKey(reporterId));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getDescription(), (Object)description);
        this.description = description;
        this.modifiedFields.put("description", modifiedValue);
        this.updateGV("description", description);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getEnvironment(), (Object)environment);
        this.environment = environment;
        this.modifiedFields.put("environment", modifiedValue);
        this.updateGV("environment", environment);
    }

    public ApplicationUser getAssigneeUser() {
        return this.getAssignee();
    }

    public ApplicationUser getAssignee() {
        if (this.assignee == null && this.assigneeId != null) {
            this.assignee = this.getUserByKey(this.assigneeId);
        }
        return this.assignee;
    }

    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssignee(ApplicationUser assignee) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getAssignee(), (Object)assignee);
        this.assignee = assignee;
        this.modifiedFields.put("assignee", modifiedValue);
        this.assigneeId = assignee != null ? ApplicationUsers.getKeyFor(assignee) : null;
        this.updateGV("assignee", this.assigneeId);
    }

    public void setAssigneeId(String assigneeKey) {
        this.setAssignee(this.getUserByKey(assigneeKey));
    }

    public Collection<ProjectComponent> getComponentObjects() {
        return this.getComponents();
    }

    public Collection<ProjectComponent> getComponents() {
        if (this.components == null) {
            this.components = this.projectComponentManager.findComponentsByIssue((Issue)this);
            if (this.components == null) {
                return Collections.emptyList();
            }
        }
        return Lists.newArrayList(this.components);
    }

    public void setComponent(Collection<ProjectComponent> components) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getComponentObjects(), components);
        this.components = components;
        this.modifiedFields.put("components", modifiedValue);
    }

    public Collection<Version> getFixVersions() {
        if (this.fixVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getFixVersionsFor((Issue)this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.fixVersions = newValue;
            } else {
                this.fixVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.fixVersions);
    }

    public void setFixVersions(Collection<Version> fixVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getFixVersions(), fixVersions);
        this.fixVersions = fixVersions;
        this.modifiedFields.put("fixVersions", modifiedValue);
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Timestamp dueDate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getDueDate(), (Object)dueDate);
        this.dueDate = dueDate;
        this.modifiedFields.put("duedate", modifiedValue);
        this.updateGV("duedate", dueDate);
    }

    public GenericValue getSecurityLevel() {
        if (this.securityLevel == null && this.securityLevelId != null) {
            try {
                this.securityLevel = this.issueSecurityLevelManager.getIssueSecurityLevel(this.securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Cannot retrieve security level with id '" + this.securityLevelId + "'.", (Throwable)e);
            }
        }
        return this.securityLevel;
    }

    public Long getSecurityLevelId() {
        return this.securityLevelId;
    }

    public void setSecurityLevelId(Long securityLevelId) {
        if (securityLevelId == null) {
            this.setSecurityLevel(null);
        } else {
            GenericValue securityLevelGV = null;
            try {
                securityLevelGV = this.issueSecurityLevelManager.getIssueSecurityLevel(securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            if (securityLevelGV == null) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            this.setSecurityLevel(securityLevelGV);
        }
    }

    public void setSecurityLevel(GenericValue securityLevel) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getSecurityLevel(), (Object)securityLevel);
        this.securityLevel = securityLevel;
        this.modifiedFields.put("security", modifiedValue);
        this.securityLevelId = securityLevel != null ? securityLevel.getLong("id") : null;
        this.updateGV("security", this.securityLevelId);
    }

    public Priority getPriority() {
        if (this.priority == null && this.priorityId != null) {
            this.priority = this.constantsManager.getPriorityObject(this.priorityId);
        }
        return this.priority;
    }

    public void setPriority(GenericValue priority) {
        if (priority != null) {
            this.setPriority(this.constantsManager.getPriorityObject(priority.getString("id")));
        } else {
            this.setPriority((Priority)null);
        }
    }

    public void setPriority(Priority priority) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getPriority(), (Object)priority);
        this.priority = priority;
        this.modifiedFields.put("priority", modifiedValue);
        this.priorityId = priority != null ? priority.getId() : null;
        this.updateGV("priority", this.priorityId);
    }

    public void setPriorityObject(Priority priority) {
        this.setPriority(priority);
    }

    public void setPriorityId(String priorityId) {
        if (priorityId != null) {
            this.setPriority(this.constantsManager.getPriorityObject(priorityId));
        } else {
            this.setPriority((Priority)null);
        }
    }

    public String getResolutionId() {
        return this.resolutionId;
    }

    public Resolution getResolution() {
        if (this.resolution == null && this.resolutionId != null) {
            this.resolution = this.constantsManager.getResolution(this.resolutionId);
        }
        return this.resolution;
    }

    public void setResolutionId(String resolutionId) {
        if (resolutionId != null) {
            this.setResolutionObject(this.constantsManager.getResolutionObject(resolutionId));
        } else {
            this.setResolution(null);
        }
    }

    public void setResolution(Resolution resolution) {
        Resolution oldValue = this.getResolution();
        this.resolution = resolution != null ? this.constantsManager.getResolution(resolution.getId()) : null;
        this.modifiedFields.put("resolution", new ModifiedValue((Object)oldValue, (Object)this.resolution));
        if (resolution != null && resolution.getId() != null) {
            String oldResolutionId = this.resolutionId;
            this.resolutionId = resolution.getId();
            if (!this.resolutionId.equals(oldResolutionId) || this.resolutionDate == null) {
                this.setResolutionDate(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            this.resolutionId = null;
            this.setResolutionDate(null);
        }
        this.updateGV("resolution", this.resolutionId);
    }

    public void setResolutionObject(Resolution resolution) {
        this.setResolution(resolution);
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.genericValue != null) {
            return this.genericValue.getString("key");
        }
        return null;
    }

    public Long getNumber() {
        return this.issueNumber;
    }

    public void setKey(String key) {
        this.setProjectId(null);
        this.setNumber(null);
        if (key != null) {
            IssueKey issueKey = IssueKey.from((String)key);
            Project project = this.projectManager.getProjectObjByKey(issueKey.getProjectKey());
            if (project == null) {
                throw new IllegalArgumentException(String.format("Invalid project key '%s'", issueKey.getProjectKey()));
            }
            this.setProjectObject(project);
            this.setNumber(issueKey.getIssueNumber());
        }
        this.initializeKey();
    }

    public void setNumber(Long number) {
        this.issueNumber = number;
        this.updateGV("number", number);
        this.initializeKey();
    }

    public Long getVotes() {
        return this.votes;
    }

    public void setVotes(Long votes) {
        this.votes = votes;
        this.updateGV("votes", votes);
    }

    public Long getWatches() {
        return this.watches;
    }

    public void setWatches(Long watches) {
        this.watches = watches;
        this.updateGV("watches", watches);
    }

    public Collection<Version> getAffectedVersions() {
        if (this.affectedVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getAffectedVersionsFor((Issue)this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.affectedVersions = newValue;
            } else {
                this.affectedVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.affectedVersions);
    }

    public void setAffectedVersions(Collection<Version> affectedVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getAffectedVersions(), affectedVersions);
        this.affectedVersions = affectedVersions;
        this.modifiedFields.put("versions", modifiedValue);
    }

    public String getString(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getString(name);
        }
        throw new IllegalStateException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public Timestamp getTimestamp(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getTimestamp(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public Long getLong(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getLong(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
        this.updateGV("created", created);
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
        this.updateGV("updated", updated);
    }

    public Timestamp getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Timestamp resolutionDate) {
        this.resolutionDate = resolutionDate;
        this.updateGV("resolutiondate", resolutionDate);
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    public Object getCustomFieldValue(CustomField customField) {
        if (!this.customFieldValues.containsKey(customField)) {
            if (this.genericValue != null) {
                this.customFieldValues.put(customField, customField.getValue((Issue)this));
            } else {
                this.customFieldValues.put(customField, customField.getDefaultValue((Issue)this));
            }
        }
        return this.customFieldValues.get(customField);
    }

    public void setCustomFieldValue(CustomField customField, Object value) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getCustomFieldValue(customField), value);
        this.customFieldValues.put(customField, value);
        this.modifiedFields.put(customField.getId(), modifiedValue);
    }

    public Object getExternalFieldValue(String fieldId) {
        return this.externalFields.get(fieldId);
    }

    public void setExternalFieldValue(String fieldId, Object newValue) {
        this.setExternalFieldValue(fieldId, null, newValue);
    }

    public void setExternalFieldValue(String fieldId, Object oldValue, Object newValue) {
        ModifiedValue modifiedValue = new ModifiedValue(oldValue, newValue);
        this.externalFields.put(fieldId, newValue);
        this.modifiedFields.put(fieldId, modifiedValue);
    }

    public boolean isSubTask() {
        return this.getParentId() != null;
    }

    public Long getParentId() {
        if (this.parentId == null && this.getGenericValue() != null && !this.hasNoParentId) {
            this.parentId = this.subTaskManager.getParentIssueId((Issue)this);
            if (this.parentId == null) {
                this.hasNoParentId = true;
            }
        }
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
        this.parentIssue = null;
        this.parentIssueLazyReference.reset();
    }

    public void setParentObject(Issue parentIssue) throws IllegalArgumentException {
        if (parentIssue == null) {
            this.parentId = null;
        } else {
            if (parentIssue.getId() == null) {
                throw new IllegalArgumentException("Parent issue cannot have a null ID.");
            }
            this.parentId = parentIssue.getId();
        }
        this.parentIssue = parentIssue;
        this.parentIssueLazyReference.reset();
    }

    @Override
    public Issue getParentObject() {
        if (this.parentIssue == null) {
            return (Issue)this.parentIssueLazyReference.get();
        }
        return this.parentIssue;
    }

    @Override
    public GenericValue getParent() {
        if (this.parentIssue == null) {
            return super.getParent();
        }
        return this.parentIssue.getGenericValue();
    }

    public Collection<GenericValue> getSubTasks() {
        if (this.isCreated()) {
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)this.subTasksLazyReference.get()), (Function)new Function<Issue, GenericValue>(){

                public GenericValue apply(Issue issue) {
                    return issue.getGenericValue();
                }
            }));
        }
        return Collections.emptyList();
    }

    public Collection<Issue> getSubTaskObjects() {
        if (this.isCreated()) {
            return (Collection)this.subTasksLazyReference.get();
        }
        return Collections.emptyList();
    }

    public boolean isCreated() {
        return this.getGenericValue() != null;
    }

    public Status getStatus() {
        if (this.status == null && this.statusId != null) {
            this.status = this.constantsManager.getStatus(this.statusId);
        }
        return this.status;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
        this.status = null;
        this.updateGV("status", statusId);
    }

    public void setLabels(Set<Label> labels) {
        String oldLabels = StringUtils.join(this.getLabels(), (String)" ");
        String newLabels = StringUtils.join(labels, (String)" ");
        ModifiedValue modifiedValue = new ModifiedValue((Object)oldLabels, (Object)newLabels);
        this.labels = labels;
        this.modifiedFields.put("labels", modifiedValue);
    }

    public Set<Label> getLabels() {
        if (this.labels == null) {
            this.labels = this.genericValue != null ? this.labelManager.getLabels(this.getId()) : Collections.emptySet();
        }
        return this.labels;
    }

    public void setStatus(Status status) {
        if (status != null) {
            this.status = this.constantsManager.getStatus(status.getId());
            this.statusId = status.getId();
        } else {
            this.status = null;
            this.statusId = null;
        }
        this.updateGV("status", this.statusId);
    }

    public void setStatusObject(Status status) {
        this.setStatus(status);
    }

    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setOriginalEstimate(Long originalEstimate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getOriginalEstimate(), (Object)originalEstimate);
        this.originalEstimate = originalEstimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeoriginalestimate", originalEstimate);
    }

    public Long getEstimate() {
        return this.estimate;
    }

    public void setEstimate(Long estimate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getEstimate(), (Object)estimate);
        this.estimate = estimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeestimate", estimate);
    }

    public Long getTimeSpent() {
        return this.timespent;
    }

    public void setTimeSpent(Long timespent) {
        this.timespent = timespent;
        this.updateGV("timespent", timespent);
    }

    public IssueRenderContext getIssueRenderContext() {
        return new IssueRenderContext((Issue)this);
    }

    public void store() {
        try {
            if (!this.isCreated()) {
                this.creatorId = this.getLoggedInUserKey();
                if (this.creatorId == null && this.reporterId != null) {
                    this.creatorId = this.reporterId;
                }
                FieldMap fields = new FieldMap();
                fields.put((Object)"project", (Object)this.projectId);
                fields.put((Object)"type", (Object)this.issueTypeId);
                fields.put((Object)"created", (Object)this.created);
                fields.put((Object)"updated", (Object)this.updated);
                fields.put((Object)"duedate", (Object)this.dueDate);
                fields.put((Object)"resolutiondate", (Object)this.resolutionDate);
                fields.put((Object)"assignee", (Object)this.assigneeId);
                fields.put((Object)"reporter", (Object)this.reporterId);
                fields.put((Object)"creator", (Object)this.creatorId);
                fields.put((Object)"summary", (Object)this.summary);
                fields.put((Object)"description", (Object)this.description);
                fields.put((Object)"environment", (Object)this.environment);
                fields.put((Object)"priority", (Object)this.priorityId);
                fields.put((Object)"status", (Object)this.statusId);
                fields.put((Object)"number", (Object)this.issueNumber);
                fields.put((Object)"votes", (Object)this.votes);
                fields.put((Object)"watches", (Object)this.watches);
                fields.put((Object)"security", (Object)this.securityLevelId);
                fields.put((Object)"timeoriginalestimate", (Object)this.originalEstimate);
                fields.put((Object)"timeestimate", (Object)this.estimate);
                fields.put((Object)"timespent", (Object)this.timespent);
                fields.put((Object)"archived", (Object)this.archived);
                fields.put((Object)"workflowId", (Object)this.workflowId);
                this.genericValue = EntityUtils.createValue("Issue", (Map<String, Object>)fields);
                this.copyValuesFromGV(this.genericValue);
            } else {
                this.genericValue.store();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while storing issue.", (Throwable)e);
        }
    }

    public Map<String, ModifiedValue> getModifiedFields() {
        return this.modifiedFields;
    }

    public void resetModifiedFields() {
        this.modifiedFields.clear();
        this.externalFields.clear();
    }

    private void initializeKey() {
        this.key = this.getProjectObject() != null && this.issueNumber != null ? IssueKey.format((Project)this.getProjectObject(), (long)this.issueNumber) : null;
    }

    private void updateGV(String fieldName, Object fieldValue) {
        if (this.genericValue != null) {
            this.genericValue.set(fieldName, fieldValue);
        }
    }

    private ApplicationUser getUserByKey(String userKey) {
        if (userKey != null) {
            return this.userManager.getUserByKeyEvenWhenUnknown(userKey);
        }
        return null;
    }

    private String getLoggedInUserKey() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return user != null ? user.getKey() : null;
    }

    public String toString() {
        String key = this.getKey();
        return key == null ? this.summary : key;
    }
}

