/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.issue.archiving.query.ArchivedIssuesProvider;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class DefaultArchivedIssueSearchService
implements ArchivedIssueSearchService {
    @Inject
    private final IssueFactory issueFactory;
    @Inject
    private final OfBizDelegator ofBizDelegator;
    private final ProjectManager projectManager;
    private final ArchivedIssuesProvider archivedIssuesProvider;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");

    public DefaultArchivedIssueSearchService(IssueFactory issueFactory, ProjectManager projectManager, OfBizDelegator ofBizDelegator, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext authenticationContext, ProjectService projectService, QueryDslAccessor queryDslAccessor, I18nHelper.BeanFactory i18nFactory, IssueManager issueManager, ConstantsManager constantsManager, ArchivedStatistics archivedStatistics) {
        this.issueFactory = issueFactory;
        this.projectManager = projectManager;
        this.ofBizDelegator = ofBizDelegator;
        this.globalPermissionManager = globalPermissionManager;
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.i18nFactory = i18nFactory;
        this.constantsManager = constantsManager;
        this.archivedIssuesProvider = new ArchivedIssuesProvider(queryDslAccessor, (ArchivedProjectManager)ComponentAccessor.getComponent(ArchivedProjectManager.class), issueManager, archivedStatistics);
        this.permissionManager = ComponentAccessor.getPermissionManager();
    }

    @Override
    public List<Issue> getArchivedIssuesMatchingTypesInProjects(List<Long> projectIds, List<String> issueTypeIds) {
        EntityExpr whereMatchProject = new EntityExpr("project", EntityOperator.IN, projectIds);
        EntityExpr whereMatchIssueType = new EntityExpr("type", EntityOperator.IN, issueTypeIds);
        EntityExpr whereArchived = new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(true));
        EntityConditionList conditions = new EntityConditionList((List)ImmutableList.of((Object)whereArchived, (Object)whereMatchProject, (Object)whereMatchIssueType), EntityOperator.AND);
        return this.issueFactory.getIssues((Collection)this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)conditions).getCompleteList());
    }

    @Override
    public ArchivedIssueSearchService.ValidationResult validateSearch(ArchivedIssueSearchService.ArchiveSearchRequest request) {
        boolean isGlobalBrowse = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getLoggedInUser()) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.of((String)"GLOBAL_BROWSE_ARCHIVE"), this.authenticationContext.getLoggedInUser());
        Collection browseProjects = ((List)this.projectService.getAllProjectsForAction(this.authenticationContext.getLoggedInUser(), ProjectAction.VIEW_ARCHIVED_PROJECT).get()).stream().filter(project -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_ARCHIVE, project, this.authenticationContext.getLoggedInUser())).collect(Collectors.toList());
        if (!isGlobalBrowse && browseProjects.isEmpty()) {
            if (Users.isAnonymous((ApplicationUser)this.authenticationContext.getLoggedInUser())) {
                return this.createErrorResult(ErrorCollection.Reason.NOT_LOGGED_IN, "admin.errors.archivedissue.error.permission.required");
            }
            return this.createErrorResult(ErrorCollection.Reason.FORBIDDEN, "admin.errors.archivedissue.error.permission.required");
        }
        if (request.archivedBefore != null && request.archivedAfter != null && request.archivedBefore < request.archivedAfter) {
            return this.createErrorResult(ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.invalid.date.range");
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        for (String keyOrId : request.projectKeysOrIds) {
            ProjectService.GetProjectResult projectForAction = this.getProjectForAction(this.authenticationContext.getLoggedInUser(), DefaultArchivedIssueSearchService.parse(keyOrId), ProjectAction.VIEW_ARCHIVED_PROJECT);
            if (projectForAction.isValid()) {
                if (!isGlobalBrowse && !browseProjects.contains(projectForAction.get())) {
                    return this.createErrorResult(keyOrId, ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.project.browse.not.allowed");
                }
                projects.add(projectForAction.get());
                continue;
            }
            return this.createErrorResult(keyOrId, ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.project.not.found");
        }
        if (projects.isEmpty() && !isGlobalBrowse) {
            projects.addAll(browseProjects);
        }
        return this.validateSearch(request, projects);
    }

    @Override
    public ArchivedIssueSearchService.ValidationResult validateSearchOverrideSecurity(ArchivedIssueSearchService.ArchiveSearchRequest request) {
        List<Project> projects = request.projectKeysOrIds.stream().map(DefaultArchivedIssueSearchService::parse).map(this::getProjectOverrideSecurity).collect(Collectors.toList());
        return this.validateSearch(request, projects);
    }

    private ArchivedIssueSearchService.ValidationResult validateSearch(ArchivedIssueSearchService.ArchiveSearchRequest request, Collection<Project> projects) {
        ApplicationUser applicationUser;
        ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
        ArrayList<ApplicationUser> archivedBy = new ArrayList<ApplicationUser>();
        ArrayList<ApplicationUser> reporters = new ArrayList<ApplicationUser>();
        for (String issueTypeId : request.issueTypes) {
            IssueType issueType = this.constantsManager.getIssueType(issueTypeId);
            if (issueType != null) {
                issueTypes.add(issueType);
                continue;
            }
            return this.createErrorResult(issueTypeId, ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.issue.type.not.found");
        }
        for (String archivedByKey : request.archivedBy) {
            applicationUser = ApplicationUsers.byKey(archivedByKey);
            if (applicationUser != null) {
                archivedBy.add(applicationUser);
                continue;
            }
            return this.createErrorResult(archivedByKey, ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.archived.by.not.found");
        }
        for (String reporterKey : request.reporters) {
            applicationUser = ApplicationUsers.byKey(reporterKey);
            if (applicationUser != null) {
                reporters.add(applicationUser);
                continue;
            }
            return this.createErrorResult(reporterKey, ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.archivedissue.error.reporter.not.found");
        }
        ArchiveQuery query = new ArchiveQuery.Builder().project(projects.toArray(new Project[0])).issueType(issueTypes.toArray(new IssueType[0])).reporter(reporters.toArray(new ApplicationUser[0])).archivedBy(archivedBy.toArray(new ApplicationUser[0])).archivedBefore(request.archivedBefore != null ? new Timestamp(request.archivedBefore) : null).archivedAfter(request.archivedAfter != null ? new Timestamp(request.archivedAfter) : null).maxResults(request.maxResults).build();
        return new ArchivedIssueSearchService.ValidationResult(query);
    }

    @Override
    public Stream<ArchivedIssue> search(ArchivedIssueSearchService.ValidationResult validationResult) {
        Preconditions.checkNotNull((Object)((Object)validationResult));
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull((Object)validationResult.getQuery());
        return this.archivedIssuesProvider.getArchivedIssues(validationResult.getQuery());
    }

    @Override
    public int count(ArchivedIssueSearchService.ValidationResult validationResult) {
        Preconditions.checkNotNull((Object)((Object)validationResult));
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull((Object)validationResult.getQuery());
        return this.archivedIssuesProvider.countArchivedIssues(validationResult.getQuery());
    }

    public static Either<Long, String> parse(String projectKeyOrId) {
        return DefaultArchivedIssueSearchService.isProjectId(projectKeyOrId) ? Either.left((Object)Long.parseLong(projectKeyOrId)) : Either.right((Object)projectKeyOrId);
    }

    private static boolean isProjectId(String projectIdOrKey) {
        return PROJECT_ID_PATTERN.matcher(projectIdOrKey).matches();
    }

    private ProjectService.GetProjectResult getProjectForAction(ApplicationUser user, Either<Long, String> projectKeyOrId, ProjectAction projectAction) {
        return (ProjectService.GetProjectResult)projectKeyOrId.fold(id -> this.projectService.getProjectByIdForAction(user, id, projectAction), key -> this.projectService.getProjectByKeyForAction(user, key, projectAction));
    }

    private Project getProjectOverrideSecurity(Either<Long, String> projectKeyOrId) {
        return (Project)projectKeyOrId.fold(id -> this.projectManager.getProjectObj(id), key -> this.projectManager.getProjectObjByKey(key));
    }

    private ArchivedIssueSearchService.ValidationResult createErrorResult(ErrorCollection.Reason failedReason, String errorKey) {
        return this.createErrorResult("", failedReason, errorKey);
    }

    private ArchivedIssueSearchService.ValidationResult createErrorResult(String identifier, ErrorCollection.Reason failedReason, String errorKey) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(this.i18nFactory.getInstance(this.authenticationContext.getLoggedInUser()).getText(errorKey, identifier), failedReason);
        return new ArchivedIssueSearchService.ValidationResult((ErrorCollection)simpleErrorCollection);
    }
}

