/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.issue.archiving.query.ArchivedState;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSPropertyDate;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ArchivedIssuesProvider {
    private static final String ARCHIVED_DATE_KEY = "jira.archiving.projects.date";
    private static final String ARCHIVED_BY_KEY = "jira.archiving.projects.archived.by";
    private final QueryDslAccessor queryDslAccessor;
    private final ArchivedProjectManager archivedProjectManager;
    private final IssueManager issueManager;
    private final ArchivedStatistics archivedStatistics;

    public ArchivedIssuesProvider(QueryDslAccessor queryDslAccessor, ArchivedProjectManager archivedProjectManager, IssueManager issueManager, ArchivedStatistics archivedStatistics) {
        this.queryDslAccessor = queryDslAccessor;
        this.archivedProjectManager = archivedProjectManager;
        this.issueManager = issueManager;
        this.archivedStatistics = archivedStatistics;
    }

    public Stream<ArchivedIssue> getArchivedIssues(ArchiveQuery query) {
        return this.getArchivedIssuesIds(query).stream().map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0)).map(this::convertToArchivedIssue);
    }

    public int countArchivedIssues(ArchiveQuery query) {
        if (query.isEmpty()) {
            return this.archivedStatistics.getTotalArchivedIssuesCount();
        }
        return this.queryDslAccessor.executeQuery(dbConnection -> (int)this.prepareSqlQuery(query, dbConnection).fetchCount());
    }

    private ArchivedIssue convertToArchivedIssue(Issue issue) {
        if (issue.getArchivedDate() == null) {
            Project project = issue.getProjectObject();
            return new ArchivedIssue(issue, this.archivedProjectManager.getArchivedBy(project).orElse(null), Optional.ofNullable(this.archivedProjectManager.getArchivedTimestamp(project)).map(Timestamp::new).orElse(null), ArchivedState.PROJECT_ARCHIVED);
        }
        return new ArchivedIssue(issue);
    }

    private List<Long> getArchivedIssuesIds(ArchiveQuery query) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)this.prepareSqlQuery(query, dbConnection).limit((long)query.getMaxResults())).fetch());
    }

    private SQLQuery<Long> prepareSqlQuery(ArchiveQuery query, DbConnection dbConnection) {
        QIssue issue = new QIssue("issue");
        QOSPropertyDate archivedDateValue = new QOSPropertyDate("date_value");
        QOSPropertyNumber archivedByValue = new QOSPropertyNumber("by_value");
        QOSPropertyEntry archivedDateEntry = new QOSPropertyEntry("date_entry");
        QOSPropertyEntry archivedByEntry = new QOSPropertyEntry("by_entry");
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(issue.id).from((Expression)issue)).leftJoin((EntityPath)archivedDateEntry)).on((Predicate)issue.project.eq(archivedDateEntry.entityId).and((Predicate)archivedDateEntry.propertyKey.eq((Object)ARCHIVED_DATE_KEY)))).leftJoin((EntityPath)archivedDateValue)).on((Predicate)archivedDateValue.id.eq(archivedDateEntry.id))).leftJoin((EntityPath)archivedByEntry)).on((Predicate)issue.project.eq(archivedByEntry.entityId).and((Predicate)archivedByEntry.propertyKey.eq((Object)ARCHIVED_BY_KEY)))).leftJoin((EntityPath)archivedByValue)).on((Predicate)archivedByValue.id.eq(archivedByEntry.id))).where(this.buildPredicate(query, archivedDateValue, issue))).orderBy(new OrderSpecifier[]{issue.archiveddate.coalesce(new Expression[]{archivedDateValue.value}).desc(), issue.id.asc()});
    }

    private Predicate buildPredicate(ArchiveQuery query, QOSPropertyDate archivedDateValue, QIssue issue) {
        BooleanExpression expression = issue.archived.eq((Object)"Y").or((Predicate)archivedDateValue.value.isNotNull());
        return (Predicate)query.getClauses().stream().map(ArchiveQuery.QueryClause::toExpression).reduce(expression, BooleanExpression::and);
    }
}

