/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentAdapterImpl;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileAttachments {
    private static final Logger log = LoggerFactory.getLogger(FileAttachments.class);
    private static final long BUCKET_SIZE = 10000L;

    public static File getAttachmentDirectoryForIssue(File rootDir, String originalProjectKey, String issueKey) {
        File projectDir = new File(rootDir, originalProjectKey);
        File bucketDir = new File(projectDir, FileAttachments.computeIssueBucketDir(issueKey));
        return new File(bucketDir, FileAttachments.computeIssueKeyForOriginalProjectKey(originalProjectKey, issueKey));
    }

    public static String computeIssueKeyForOriginalProjectKey(String originalProjectKey, String issueKey) {
        long issueNumber = IssueKey.from((String)issueKey).getIssueNumber();
        return IssueKey.format((String)originalProjectKey, (long)issueNumber);
    }

    public static File getAttachmentFileHolder(AttachmentKey attachment, File rootDir) {
        File issueDir = FileAttachments.getAttachmentDirectoryForIssue(rootDir, attachment.getProjectKey(), attachment.getIssueKey());
        return FileAttachments.getAttachmentFileHolder(new AttachmentAdapterImpl(attachment.getAttachmentId(), attachment.getAttachmentFilename()), issueDir);
    }

    public static File getDefaultAttachmentFileHolder(AttachmentKey attachment, File rootDir) {
        File issueDir = FileAttachments.getAttachmentDirectoryForIssue(rootDir, attachment.getProjectKey(), attachment.getIssueKey());
        return FileAttachments.getDefaultAttachmentFile(new AttachmentAdapterImpl(attachment.getAttachmentId(), attachment.getAttachmentFilename()), issueDir);
    }

    @Deprecated
    public static File getAttachmentFileHolder(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        File defaultFile = FileAttachments.getDefaultAttachmentFile(attachment, attachmentDir);
        if (defaultFile.exists()) {
            return defaultFile;
        }
        File projectIssueFile = FileAttachments.getProjectIssueFile(attachment, attachmentDir);
        if (projectIssueFile.exists()) {
            return projectIssueFile;
        }
        File legacyFile = FileAttachments.getLegacyAttachmentFile(attachment, FileAttachments.getProjectIssueDirectory(attachmentDir));
        if (legacyFile.exists()) {
            return legacyFile;
        }
        File legacyBucketFile = FileAttachments.getLegacyAttachmentFile(attachment, attachmentDir);
        if (legacyBucketFile.exists()) {
            return legacyBucketFile;
        }
        File legacyAttachmentById = FileAttachments.findLegacyAttachmentById(attachment, FileAttachments.getProjectIssueDirectory(attachmentDir));
        if (legacyAttachmentById == null) {
            return defaultFile;
        }
        return legacyAttachmentById;
    }

    public static String computeIssueBucketDir(@Nonnull String issueKey) {
        long issueNumber = IssueKey.from((String)issueKey).getIssueNumber();
        long issueBucket = ((issueNumber - 1L) / 10000L + 1L) * 10000L;
        return Long.toString(issueBucket);
    }

    private static File findLegacyAttachmentById(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        final Pattern allFilesPattern = Pattern.compile("^" + attachment.getId() + "_.+");
        File[] list = attachmentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = allFilesPattern.matcher(name);
                return m.matches();
            }
        });
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Pattern thumbnailExcludingPattern = Pattern.compile("^" + attachment.getId() + "_(?!thumb_).+");
            File firstFile = null;
            int matchCount = 0;
            for (File file : list) {
                if (!thumbnailExcludingPattern.matcher(file.getName()).matches()) continue;
                ++matchCount;
                if (firstFile != null) continue;
                firstFile = file;
            }
            if (matchCount == 1) {
                return firstFile;
            }
            log.warn("More than one file found for attachment id " + attachment.getId() + " in " + attachmentDir + ". The first entry will be returned.");
        }
        return list[0];
    }

    private static File getProjectIssueFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(FileAttachments.getProjectIssueDirectory(attachmentDirectory), attachment.getId().toString());
    }

    private static File getProjectIssueDirectory(File attachmentDirectory) {
        String issueKey = attachmentDirectory.getName();
        File baseDirectory = attachmentDirectory.getParentFile().getParentFile();
        return new File(baseDirectory, issueKey);
    }

    private static File getDefaultAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId().toString());
    }

    private static File getLegacyAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        return new File(attachmentDir, attachment.getId() + "_" + attachment.getFilename());
    }

    public static File validateFileForAttachment(Attachment metaData, File file) {
        Preconditions.checkArgument((file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (Object)"Source file is unavailable");
        Preconditions.checkArgument((file.length() == metaData.getFilesize().longValue() ? 1 : 0) != 0, (String)"Source file has different length to what is store in Attachment metadata. Expected %s, but is %s.", (Object)metaData.getFilesize(), (long)file.length());
        return file;
    }

    private FileAttachments() {
    }
}

