/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.web.ServletContextProvider;
import javax.servlet.ServletContext;

public final class MimetypesFileTypeMap {
    public static String getContentType(String filename) {
        ServletContext context = ServletContextProvider.getServletContext();
        String nullableContentType = MimetypesFileTypeMap.getNullableContentType(filename, context);
        if (nullableContentType == null) {
            return "application/octet-stream";
        }
        return nullableContentType;
    }

    private static String getNullableContentType(String filename, ServletContext context) {
        if (context != null) {
            return context.getMimeType(filename);
        }
        return javax.activation.MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(filename);
    }

    private MimetypesFileTypeMap() {
    }
}

