/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;

public abstract class WithDirectoryAccessorThumbnailAccessor
implements ThumbnailAccessor {
    private final AttachmentDirectoryAccessor attachmentDirectoryAccessor;

    public WithDirectoryAccessorThumbnailAccessor(AttachmentDirectoryAccessor ada) {
        this.attachmentDirectoryAccessor = ada;
    }

    @Override
    @Nonnull
    public final File getThumbnailDirectory(@Nonnull Issue issue) {
        return this.attachmentDirectoryAccessor.getThumbnailDirectory(issue);
    }

    @Override
    @Nonnull
    public final File getThumbnailDirectory(@Nonnull Issue issue, boolean createDirectory) {
        return this.attachmentDirectoryAccessor.getThumbnailDirectory(issue, createDirectory);
    }

    @Override
    public Promise<Void> deleteThumbnailDirectory(@Nonnull Issue issue) {
        File thumbnailDirectory = this.attachmentDirectoryAccessor.getThumbnailDirectory(issue, false);
        try {
            FileUtils.deleteDirectory((File)thumbnailDirectory);
            return Promises.promise(null);
        }
        catch (IOException e) {
            return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
        }
    }

    protected final AttachmentDirectoryAccessor getAttachmentDirectoryAccessor() {
        return this.attachmentDirectoryAccessor;
    }
}

