/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfigContextPersisterWorker {
    public static final String ENTITY_TABLE_NAME = "ConfigurationContext";
    public static final String ENTITY_PROJECT = "project";
    public static final String ENTITY_KEY = "key";
    public static final String ENTITY_SCHEME_ID = "fieldconfigscheme";
    public static final String ENTITY_ID = "id";
    static final int BATCH_SIZE = Collections.min(Arrays.asList(1000, 2000, 30000));
    private final OfBizDelegator delegator;
    private final ProjectManager projectManager;
    private static final Logger log = LoggerFactory.getLogger(FieldConfigContextPersisterWorker.class);
    private final CachedReference<Multimap<Long, GenericValue>> configContextsBySchemeId;

    public FieldConfigContextPersisterWorker(OfBizDelegator delegator, ProjectManager projectManager, CacheManager cacheManager) {
        this.delegator = delegator;
        this.projectManager = projectManager;
        this.configContextsBySchemeId = cacheManager.getCachedReference(this.getClass().getName() + ".configContextsBySchemeId", this::loadConfigContext);
    }

    @Nonnull
    public List<JiraContextNode> getAllContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        return ((Multimap)this.configContextsBySchemeId.get()).get((Object)fieldConfigScheme.getId()).stream().filter(this::filterGenericValues).map(this::transformToDomainObject).collect(Collectors.toList());
    }

    public void removeContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId()));
        this.invalidateAll();
        log.debug("{} contexts deleted for field config scheme with id '{}'.", (Object)result, (Object)fieldConfigScheme.getId());
    }

    public void removeContextsForProject(@Nonnull Project project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT, (Object)project.getId()));
        this.invalidateAll();
        log.debug("{} contexts deleted for {}.", (Object)result, (Object)project);
    }

    public void store(String fieldKey, Collection<? extends JiraContextNode> contextNodes, FieldConfigScheme fieldConfigScheme) {
        if (contextNodes != null && !contextNodes.isEmpty()) {
            log.debug("We start updating schemas for the {} projects.", (Object)contextNodes.size());
            StreamSupport.stream(Iterables.partition(contextNodes, (int)BATCH_SIZE).spliterator(), false).forEach(nodesBatch -> {
                this.removeContextsForField(fieldKey, (List<? extends JiraContextNode>)nodesBatch);
                this.storeAllContexts(fieldKey, (Collection<? extends JiraContextNode>)nodesBatch, fieldConfigScheme);
            });
            this.invalidateAll();
        } else {
            log.debug("The affected projects was empty so we did not perform any operations.");
        }
    }

    @Nullable
    @Deprecated
    public Object retrieve(@Nullable JiraContextNode context, String key) {
        List result;
        if (context != null && (result = this.delegator.findByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap())) != null && !result.isEmpty()) {
            Long schemeId = ((GenericValue)result.iterator().next()).getLong(ENTITY_SCHEME_ID);
            if (result.size() > 1) {
                log.warn("More than one FieldConfigScheme returned for a given context. Database may be corrupted.Returning first Long: {}. Context: {} with key: {} returned {}.", new Object[]{schemeId, context, key, result});
            }
            return schemeId;
        }
        return null;
    }

    @Deprecated
    public void store(String fieldId, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        if (this.retrieve(contextNode, fieldId) != null) {
            this.remove(contextNode, fieldId);
        }
        if (fieldConfigScheme != null) {
            MapBuilder<String, Object> props = this.transformToFieldsMap(contextNode);
            props.add((Object)ENTITY_KEY, (Object)fieldId);
            props.add((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId());
            this.delegator.createValue(ENTITY_TABLE_NAME, props.toMap());
        }
        this.invalidateAll();
    }

    @Deprecated
    public void remove(@Nullable JiraContextNode context, @Nullable String key) {
        if (context != null && key != null) {
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap());
            this.invalidateAll();
        } else {
            log.warn("Context or key was null. Nothing was removed");
        }
    }

    void invalidateAll() {
        this.configContextsBySchemeId.reset();
    }

    private MapBuilder<String, Object> transformToFieldsMap(JiraContextNode contextNode) {
        return MapBuilder.newBuilder((Map)contextNode.appendToParamsMap(Collections.emptyMap()));
    }

    private void removeContextsForField(String fieldKey, List<? extends JiraContextNode> batch) {
        List projectsId = batch.stream().map(IssueContext::getProjectId).collect(Collectors.toList());
        EntityExpr deleteCondition = new EntityExpr((EntityCondition)new EntityExpr(ENTITY_KEY, EntityOperator.EQUALS, (Object)fieldKey), EntityOperator.AND, (EntityCondition)new EntityExpr(ENTITY_PROJECT, EntityOperator.IN, projectsId));
        int deletedCount = this.delegator.removeByCondition(ENTITY_TABLE_NAME, (EntityCondition)deleteCondition);
        log.debug("{} contexts deleted for field {}.", (Object)deletedCount, (Object)fieldKey);
    }

    private void storeAllContexts(String fieldKey, Collection<? extends JiraContextNode> contextNodes, FieldConfigScheme fieldConfigScheme) {
        log.debug("Start updating {} projects", (Object)contextNodes.size());
        if (fieldConfigScheme != null) {
            List updatedContext = contextNodes.stream().map(context -> FieldConfigContextPersisterWorker.makeConfigurationContext(this.delegator, fieldKey, context, fieldConfigScheme)).collect(Collectors.toList());
            this.delegator.storeAll(updatedContext);
        } else {
            log.debug("Field config scheme was null what cause we do not update anything.");
        }
    }

    private JiraContextNode transformToDomainObject(GenericValue contextAsGv) {
        return new ProjectContext(contextAsGv.getLong(ENTITY_PROJECT), this.projectManager);
    }

    private boolean filterGenericValues(@Nonnull GenericValue contextAsGv) {
        Long projectId = contextAsGv.getLong(ENTITY_PROJECT);
        return projectId == null || this.projectManager.getProjectObj(projectId) != null;
    }

    private Multimap<Long, GenericValue> loadConfigContext() {
        Stopwatch timer = Stopwatch.createStarted();
        List genericValues = this.delegator.findAll(ENTITY_TABLE_NAME);
        ArrayListMultimap cacheValues = ArrayListMultimap.create();
        for (GenericValue genericValue : genericValues) {
            cacheValues.put((Object)genericValue.getLong(ENTITY_SCHEME_ID), (Object)genericValue);
        }
        timer.stop();
        log.debug("ConfigurationContext cache of {} element[s] loaded in {}s.", (Object)genericValues.size(), (Object)timer.elapsed(TimeUnit.SECONDS));
        return cacheValues;
    }

    private static GenericValue makeConfigurationContext(OfBizDelegator delegator, String fieldKey, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        MapBuilder props = MapBuilder.newBuilder((Map)contextNode.appendToParamsMap(Collections.emptyMap()));
        Long entityId = delegator.getDelegatorInterface().getNextSeqId(ENTITY_TABLE_NAME);
        props.add((Object)ENTITY_KEY, (Object)fieldKey);
        props.add((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId());
        props.add((Object)ENTITY_ID, (Object)entityId);
        return delegator.makeValue(ENTITY_TABLE_NAME, props.toMap());
    }
}

