/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.StatusSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.StatusStatisticsMapper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusFormatter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class StatusSystemField
extends NavigableFieldImpl
implements SearchableField,
RestAwareField,
ExportableSystemField {
    private final StatusStatisticsMapper statusStatisticsMapper;
    private final ConstantsManager constantsManager;
    private final SearchHandlerFactory searchHandlerFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final StatusFormatter statusFormatter;

    public StatusSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, StatusStatisticsMapper statusStatisticsMapper, ConstantsManager constantsManager, StatusSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls, StatusFormatter statusFormatter) {
        super("status", "issue.field.status", "issue.column.heading.status", "DESC", templatingEngine, applicationProperties, authenticationContext);
        this.statusStatisticsMapper = statusStatisticsMapper;
        this.constantsManager = constantsManager;
        this.searchHandlerFactory = searchHandlerFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.statusFormatter = statusFormatter;
    }

    public LuceneFieldSorter getSorter() {
        return this.statusStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map<String, Object> displayParams, Issue issue) {
        return this.statusFormatter.getColumnViewHtml(issue.getStatusObject(), displayParams);
    }

    private Long getStatusTypeIdByName(String stringValue) throws FieldValidationException {
        for (Status status : this.constantsManager.getStatuses()) {
            if (!stringValue.equalsIgnoreCase(status.getName())) continue;
            return Long.valueOf(status.getId());
        }
        throw new FieldValidationException("Invalid status name '" + stringValue + "'.");
    }

    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        Status status;
        Long statusId;
        if (TextUtils.stringSet((String)changeHistory) && (statusId = this.getStatusTypeIdByName(changeHistory)) != null && (status = this.constantsManager.getStatusObject(statusId.toString())) != null) {
            return status.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        throw new UnsupportedOperationException("This method is only called for fields that implement " + OrderableField.class.getSimpleName() + " interface. But " + this.getClass().getSimpleName() + " does not implement it.");
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"status", (String)"status");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)StatusJsonBean.bean((Status)issue.getStatusObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)issue.getStatus().getNameTranslation());
    }
}

