/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class EditableUserColumnLayoutImpl
extends EditableColumnLayoutImpl
implements EditableUserColumnLayout {
    private final ApplicationUser user;

    public EditableUserColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ApplicationUser user, ColumnLayout.ColumnConfig columnConfig) {
        super(new ArrayList<ColumnLayoutItem>(columnLayoutItems), columnConfig);
        if (user == null) {
            throw new IllegalArgumentException("ApplicationUser cannot be null.");
        }
        this.user = user;
    }

    public EditableUserColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ApplicationUser user) {
        this(columnLayoutItems, user, ColumnLayout.ColumnConfig.USER);
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public List<ColumnLayoutItem> getColumnLayoutItems() {
        FieldManager fieldManager = ComponentAccessor.getFieldManager();
        LinkedList<ColumnLayoutItem> columnLayoutItems = new LinkedList<ColumnLayoutItem>();
        for (ColumnLayoutItem columnLayoutItem : this.getInternalList()) {
            if (fieldManager.isCustomField((Field)columnLayoutItem.getNavigableField())) {
                CustomField customField = (CustomField)columnLayoutItem.getNavigableField();
                if (!CustomFieldUtils.isUserHasPermissionToProjects((CustomField)customField, (ApplicationUser)this.getUser())) continue;
                columnLayoutItems.add(columnLayoutItem);
                continue;
            }
            columnLayoutItems.add(columnLayoutItem);
        }
        return columnLayoutItems;
    }
}

