/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexedChangeHistoryField;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultChangeHistoryRetriever
implements DefaultIssueIndexer.ChangeHistoryRetriever {
    private final ChangeHistoryManager changeManager;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final JqlChangeItemMapping jqlChangeItemMapping;

    public DefaultChangeHistoryRetriever(@Nonnull ChangeHistoryManager changeManager, @Nonnull IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, @Nonnull JqlChangeItemMapping jqlChangeItemMapping) {
        this.changeManager = (ChangeHistoryManager)Assertions.notNull((String)"changeManager", (Object)changeManager);
        this.indexedChangeHistoryFieldManager = (IndexedChangeHistoryFieldManager)Assertions.notNull((String)"indexedChangeHistoryFieldManager", (Object)indexedChangeHistoryFieldManager);
        this.jqlChangeItemMapping = jqlChangeItemMapping;
    }

    public List<ChangeHistoryGroup> apply(Issue issue) {
        List changeHistoryItems = this.changeManager.getAllChangeItems(issue);
        return Lists.newArrayList(this.createChangeGroupsFromChangeItems(changeHistoryItems, issue));
    }

    private Iterable<ChangeHistoryGroup> createChangeGroupsFromChangeItems(List<ChangeHistoryItem> changeHistoryItems, Issue issue) {
        ArrayList filteredChangeItems = Lists.newArrayList(this.filterChangeItems(issue, changeHistoryItems));
        Collections.sort(filteredChangeItems);
        long currentChangeGroup = -1L;
        ChangeHistoryGroup.Builder builder = new ChangeHistoryGroup.Builder();
        ArrayList builders = Lists.newArrayList((Object[])new ChangeHistoryGroup.Builder[]{builder});
        for (ChangeHistoryItem item : filteredChangeItems) {
            if (item.getChangeGroupId() != currentChangeGroup) {
                currentChangeGroup = item.getChangeGroupId();
                builder = new ChangeHistoryGroup.Builder();
                builders.add(builder);
            }
            builder.addChangeItem(item);
        }
        return Iterables.transform((Iterable)builders, (Function)new Function<ChangeHistoryGroup.Builder, ChangeHistoryGroup>(){

            public ChangeHistoryGroup apply(@Nullable ChangeHistoryGroup.Builder builder) {
                return builder.build();
            }
        });
    }

    private List<ChangeHistoryItem> filterChangeItems(Issue issue, Collection<ChangeHistoryItem> changeItems) {
        ArrayList<ChangeHistoryItem> changes = new ArrayList<ChangeHistoryItem>();
        Collection indexedChangeHistoryFields = this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFields();
        this.processDetailedChangeFields(issue, changeItems, changes, indexedChangeHistoryFields);
        Collection supportedFieldNames = this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames();
        changes.addAll(changeItems.stream().filter(ci -> !supportedFieldNames.contains(ci.getField())).collect(Collectors.toList()));
        return changes;
    }

    private void processDetailedChangeFields(Issue issue, Collection<ChangeHistoryItem> changeItems, List<ChangeHistoryItem> changes, Collection<IndexedChangeHistoryField> indexedChangeHistoryFields) {
        for (final IndexedChangeHistoryField field : indexedChangeHistoryFields) {
            ImmutableList supportedChangeItems = ImmutableList.copyOf((Iterable)Iterables.filter(changeItems, (Predicate)new Predicate<ChangeHistoryItem>(){

                public boolean apply(ChangeHistoryItem input) {
                    String fieldName = DefaultChangeHistoryRetriever.this.jqlChangeItemMapping.mapJqlClauseToFieldName(field.getFieldName());
                    return input != null && fieldName.equals(input.getField());
                }
            }));
            if (supportedChangeItems == null) continue;
            changes.addAll(field.getDateRangeBuilder().buildDateRanges(issue, (List)supportedChangeItems));
        }
    }
}

