/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.indexers.FieldIndexerWithStats;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingStatsManager {
    private static final Logger log = LoggerFactory.getLogger(IndexingStatsManager.class);
    private static final String LOG_PREFIX = "[indexing-stats]";
    private final FieldIndexerManager fieldIndexerManager;
    private final CustomFieldManager customFieldManager;
    private final IssueIndexer issueIndexer;
    private final ScheduledExecutorService executorService;

    public IndexingStatsManager(FieldIndexerManager fieldIndexerManager, CustomFieldManager customFieldManager, IssueIndexer issueIndexer, EventPublisher eventPublisher) {
        this.fieldIndexerManager = fieldIndexerManager;
        this.customFieldManager = customFieldManager;
        this.issueIndexer = issueIndexer;
        eventPublisher.register((Object)this);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("indexing-stats-%d").build());
    }

    private Integer getNumberOfIndexingThreads() {
        return this.issueIndexer instanceof DefaultIssueIndexer ? Integer.valueOf(((DefaultIssueIndexer)this.issueIndexer).getNumberOfIndexingThreads()) : null;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.executorService.scheduleAtFixedRate(this::onPeriodicStats, 0L, 5L, TimeUnit.MINUTES);
    }

    @EventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        this.executorService.shutdownNow();
    }

    @EventListener
    public void onReindexAllStarted(ReindexAllStartedEvent reindexAllStartedEvent) {
        this.resetStats();
    }

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent reindexAllCompletedEvent) {
        this.onReindexCompletedStats(reindexAllCompletedEvent.getTotalTime());
    }

    @EventListener
    public void onReindexAllCancelled(ReindexAllCancelledEvent reindexAllCancelledEvent) {
        this.onPeriodicStats();
    }

    private synchronized void resetStats() {
        log.info("{} Resetting stats.", (Object)LOG_PREFIX);
        this.fieldIndexersWithStats().forEach(FieldIndexerWithStats::reset);
    }

    private List<FieldIndexerWithStats> fieldIndexersWithStats() {
        return this.fieldIndexerManager.getAllIssueIndexers().stream().filter(FieldIndexerWithStats.class::isInstance).map(FieldIndexerWithStats.class::cast).collect(Collectors.toList());
    }

    private synchronized List<FieldIndexerWithStats.Stats> fieldIndexersStatsAndResetSnapshot() {
        return this.fieldIndexersWithStats().stream().map(FieldIndexerWithStats::resetSnapshot).collect(Collectors.toList());
    }

    synchronized void onReindexCompletedStats(long totalIndexingTimeMillis) {
        try {
            Function<FieldIndexerWithStats.Stats, LongStats> totalTimeToAddFunction = FieldIndexerWithStats.Stats::totalTimeToAddIndexMicros;
            List fieldIndexersStatsOrdered = this.fieldIndexersStatsAndResetSnapshot().stream().filter(stats -> ((LongStats)totalTimeToAddFunction.apply((FieldIndexerWithStats.Stats)stats)).sum() > 0L).sorted(Comparator.comparing(totalTimeToAddFunction, Comparator.comparing(LongStats::sum)).reversed()).collect(Collectors.toList());
            Integer numberOfIndexingThreads = this.getNumberOfIndexingThreads();
            for (int i = 0; i < fieldIndexersStatsOrdered.size(); ++i) {
                FieldIndexerWithStats.Stats stats2 = (FieldIndexerWithStats.Stats)fieldIndexersStatsOrdered.get(i);
                LongStats totalTimeToAddLongStats = totalTimeToAddFunction.apply(stats2);
                String messagePrefix = String.format("order:%d, name:%s, isKnown:%b", i + 1, this.fieldName(stats2), stats2.isKnown());
                String messageAddIndex = String.format("addIndex: {sum:%dms, avg:%.1fms, max:%dms, count:%d}", TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.sum()), (double)totalTimeToAddLongStats.avg() / 1000.0, TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.max()), totalTimeToAddLongStats.count());
                String messageIndexTime = String.format("totalIndexTime:%dms, addIndexSum/totalIndexTime:%.1f%%, numberOfIndexingThreads:%d", totalIndexingTimeMillis, 100.0 * (double)TimeUnit.MICROSECONDS.toMillis(totalTimeToAddLongStats.sum()) / (double)totalIndexingTimeMillis, numberOfIndexingThreads);
                String message = String.format("{%s, %s, %s}", messagePrefix, messageAddIndex, messageIndexTime);
                log.info("{} field indexing cost: {}", (Object)LOG_PREFIX, (Object)message);
            }
        }
        catch (Exception e) {
            log.error("{} Error when getting indexing stats after full reindex: {}", new Object[]{LOG_PREFIX, e.getMessage(), e});
        }
    }

    synchronized void onPeriodicStats() {
        try {
            List<FieldIndexerWithStats.Stats> fieldIndexerStats = this.fieldIndexersStatsAndResetSnapshot();
            if (fieldIndexerStats.stream().anyMatch(stats -> stats.snapshotTimeToAddIndexMicros().count() > 0L)) {
                this.printTopTimeToAddIndex(fieldIndexerStats, "total", FieldIndexerWithStats.Stats::totalTimeToAddIndexMicros, 10);
                this.printTopTimeToAddIndex(fieldIndexerStats, "snapshot", FieldIndexerWithStats.Stats::snapshotTimeToAddIndexMicros, 10);
            }
        }
        catch (Throwable throwable) {
            log.error("{} Error when getting periodic indexing stats: {}", new Object[]{LOG_PREFIX, throwable.getMessage(), throwable});
        }
    }

    private void printTopTimeToAddIndex(List<FieldIndexerWithStats.Stats> fieldIndexerStats, String statsName, Function<FieldIndexerWithStats.Stats, LongStats> longStatsFunction, int topN) {
        long totalSumMicros = fieldIndexerStats.stream().mapToLong(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).sum()).sum();
        String topTotalTimeToAddHeader = String.format("noFieldIndexers: %d, sum: %dms", fieldIndexerStats.size(), TimeUnit.MICROSECONDS.toMillis(totalSumMicros));
        String topTotalTimeToAdd = fieldIndexerStats.stream().filter(stats -> ((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).sum() > 0L).sorted(Comparator.comparing(longStatsFunction, Comparator.comparing(LongStats::sum)).reversed()).limit(topN).map(stats -> String.format("{field: %s, addIndex: {sum/allSum:%.1f%%, sum:%dms, avg:%.1fms, max:%dms, count:%d}}", this.fieldName((FieldIndexerWithStats.Stats)stats), 100.0 * (double)((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).sum() / (double)totalSumMicros, TimeUnit.MICROSECONDS.toMillis(((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).sum()), (double)((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).avg() / 1000.0, TimeUnit.MICROSECONDS.toMillis(((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).max()), ((LongStats)longStatsFunction.apply((FieldIndexerWithStats.Stats)stats)).count())).collect(Collectors.joining(", "));
        log.info("{} Top {} addIndex {} ({}): [{}]", new Object[]{LOG_PREFIX, topN, statsName, topTotalTimeToAddHeader, topTotalTimeToAdd});
    }

    private String fieldName(FieldIndexerWithStats.Stats stats) {
        CustomField customField;
        if (!stats.isKnown() && (customField = this.customFieldManager.getCustomFieldObject(stats.id())) != null) {
            return String.format("%s (%s)", stats.id(), customField.getFieldName());
        }
        return stats.id();
    }
}

