/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIssueIndexProvider
implements Iterable<Index.Manager> {
    private static final int DEFAULT_LOCK_TIMEOUT = 10;
    private volatile Map<IndexDirectoryFactory.Name, Index.Manager> indexes;
    private final IndexDirectoryFactory factory;
    private final ReentrantLock indexLock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(LuceneIssueIndexProvider.class);

    public LuceneIssueIndexProvider(@Nonnull IndexDirectoryFactory factory) {
        this.factory = (IndexDirectoryFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    @Override
    public Iterator<Index.Manager> iterator() {
        return this.open().values().iterator();
    }

    void close() {
        log.debug("Closing lucene index provider");
        this.withLock(() -> {
            if (this.indexes == null) {
                return null;
            }
            Map<IndexDirectoryFactory.Name, Index.Manager> localCopyOfIndexes = this.indexes;
            this.indexes = null;
            for (Map.Entry<IndexDirectoryFactory.Name, Index.Manager> manager : localCopyOfIndexes.entrySet()) {
                try {
                    manager.getValue().close();
                }
                catch (Exception e) {
                    log.error("Cannot close index manager for " + (Object)((Object)manager.getKey()), (Throwable)e);
                }
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withLock(Supplier<T> supplier) {
        try {
            if (!this.indexLock.tryLock(10L, TimeUnit.SECONDS)) throw new LockNotAcquiredException("Cannot obtain lock for LuceneIssueIndexProvider");
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.indexLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Map<IndexDirectoryFactory.Name, Index.Manager> open() {
        log.debug("Opening index provider");
        Map<IndexDirectoryFactory.Name, Index.Manager> result = this.indexes;
        if (result != null) {
            return result;
        }
        return this.withLock(() -> {
            if (this.indexes != null) {
                return this.indexes;
            }
            log.debug("Opening new version of index managers");
            this.indexes = (Map)this.factory.get();
            return this.indexes;
        });
    }

    public Index getIssueIndex() {
        return this.get(IndexDirectoryFactory.Name.ISSUE).getIndex();
    }

    public Index getCommentIndex() {
        return this.get(IndexDirectoryFactory.Name.COMMENT).getIndex();
    }

    public Index getChangeHistoryIndex() {
        return this.get(IndexDirectoryFactory.Name.CHANGE_HISTORY).getIndex();
    }

    public Index getWorklogIndex() {
        return this.get(IndexDirectoryFactory.Name.WORKLOG).getIndex();
    }

    public Index getIndex(IndexDirectoryFactory.Name indexName) {
        return this.get(indexName).getIndex();
    }

    public Index.Manager get(IndexDirectoryFactory.Name key) {
        return this.open().get((Object)key);
    }

    List<String> getIndexPaths() {
        return this.factory.getIndexPaths();
    }

    String getIndexRootPath() {
        return this.factory.getIndexRootPath();
    }

    void setMode(IndexingMode type) {
        this.factory.setIndexingMode(type);
    }

    private static class LockNotAcquiredException
    extends RuntimeException {
        private LockNotAcquiredException(String message) {
            super(message);
        }
    }
}

