/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public class SubtokenFilter
extends TokenFilter {
    private static final String TOKEN_TYPE_HOST = ClassicTokenizer.TOKEN_TYPES[5];
    private static final String TOKEN_TYPE_NUM = ClassicTokenizer.TOKEN_TYPES[6];
    private static final String TOKEN_TYPE_ALPHANUM = ClassicTokenizer.TOKEN_TYPES[0];
    private static final String TOKEN_TYPE_EXCEPTION = "EXCEPTION";
    private CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private PositionIncrementAttribute incrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private TypeAttribute typeAttribute = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private AttributeSource.State current;
    private String nextType;
    private List<CharSequence> subtokenStack = Lists.newLinkedList();

    public SubtokenFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.subtokenStack.isEmpty()) {
            this.restoreState(this.current);
            CharSequence remove = this.subtokenStack.remove(0);
            this.termAttribute.setLength(0).append(remove);
            this.incrementAttribute.setPositionIncrement(0);
            this.typeAttribute.setType(this.nextType);
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        if (TOKEN_TYPE_HOST.equals(this.typeAttribute.type()) || "word".equals(this.typeAttribute.type()) || TOKEN_TYPE_ALPHANUM.equals(this.typeAttribute.type())) {
            this.addSubtokensToStack('.', TOKEN_TYPE_EXCEPTION);
        } else if (TOKEN_TYPE_NUM.equals(this.typeAttribute.type())) {
            this.addSubtokensToStack(',', TOKEN_TYPE_NUM);
        }
        return true;
    }

    private void addSubtokensToStack(char separatorChar, String newTokenType) {
        char[] termBuffer = this.termAttribute.buffer();
        int termLength = this.termAttribute.length();
        int offset = 0;
        for (int index = 0; index <= termLength; ++index) {
            if ((index >= termLength || termBuffer[index] != separatorChar) && (index != termLength || offset <= 0)) continue;
            int subtokenLength = index - offset;
            if (subtokenLength > 0) {
                if (this.subtokenStack.isEmpty()) {
                    this.nextType = newTokenType;
                    this.current = this.captureState();
                }
                this.subtokenStack.add(this.termAttribute.subSequence(offset, subtokenLength + offset));
            }
            offset = index + 1;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.current = null;
        this.nextType = null;
        this.subtokenStack.clear();
    }
}

