/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class AttachmentIndexer
extends BaseFieldIndexer {
    private static final BytesRef TRUE = new BytesRef((CharSequence)Boolean.TRUE.toString());
    private static final BytesRef FALSE = new BytesRef((CharSequence)Boolean.FALSE.toString());

    public AttachmentIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return "attachment";
    }

    public String getDocumentFieldId() {
        return "issue_has_attachment";
    }

    public void addIndex(Document doc, Issue issue) {
        this.indexAttachment(doc, this.hasAttachments(issue));
    }

    private boolean hasAttachments(Issue issue) {
        return issue.getAttachments() != null && !issue.getAttachments().isEmpty();
    }

    private void indexAttachment(Document doc, boolean hasAttachment) {
        doc.add((IndexableField)new StringField(this.getDocumentFieldId(), String.valueOf(hasAttachment), Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), hasAttachment ? TRUE : FALSE));
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible("attachment", issue);
    }
}

