/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(DateCustomFieldIndexer.class);
    private final CustomField customField;

    public DateCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date || value == null) {
            Date date = (Date)value;
            if (date != null) {
                if (date.getTime() >= 0L) {
                    if (searchable) {
                        doc.add((IndexableField)new LongPoint(this.getDocumentFieldId(), new long[]{date.getTime()}));
                        doc.add((IndexableField)new NumericDocValuesField(this.getDocumentFieldId(), date.getTime()));
                    }
                    doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), date.getTime()));
                } else {
                    log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + date.getTime());
                }
            }
            Date sortDate = searchable ? date : null;
            String sortDateFieldName = "sort_" + this.getDocumentFieldId();
            Long sortDateValue = sortDate != null ? sortDate.getTime() : Long.MAX_VALUE;
            doc.add((IndexableField)new LongPoint(sortDateFieldName, new long[]{sortDateValue}));
            doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, sortDateValue.longValue()));
        }
    }
}

