/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(SelectCustomFieldIndexer.class);
    private final CustomField customField;

    public SelectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        try {
            Object value = this.customField.getValue(issue);
            if (value instanceof Collection) {
                ((Collection)value).stream().filter(Objects::nonNull).forEach(option -> this.addFields(doc, issue, searchable, (Option)option));
            } else if (value instanceof Option) {
                this.addFields(doc, issue, searchable, (Option)value);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid custom field option");
        }
    }

    private void addFields(Document doc, Issue issue, boolean searchable, Option value) {
        String indexValue = value.getOptionId().toString();
        if (searchable) {
            doc.add((IndexableField)new StringField(this.getDocumentFieldId(), indexValue, Field.Store.YES));
            doc.add((IndexableField)new StringField(this.getDocumentFieldId() + "_raw", indexValue, Field.Store.YES));
            doc.add((IndexableField)new SortedSetDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)indexValue)));
            doc.add((IndexableField)new SortedSetDocValuesField(this.getDocumentFieldId() + "_raw", new BytesRef((CharSequence)indexValue)));
        } else {
            doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), indexValue));
            doc.add((IndexableField)new StoredField(this.getDocumentFieldId() + "_raw", indexValue));
        }
        SecurityIndexingUtils.indexPermissions((Document)doc, (Issue)issue, (String)this.getDocumentFieldId(), (String)indexValue);
    }
}

