/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.priority;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.project.Project;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PriorityIssueSearcher {
    private final QueryDslAccessor queryDslAccessor;
    private final ConstantsManager constantsManager;

    public PriorityIssueSearcher(QueryDslAccessor queryDslAccessor, ConstantsManager constantsManager) {
        this.queryDslAccessor = queryDslAccessor;
        this.constantsManager = constantsManager;
    }

    public Set<Priority> findUsedPriorities(Project project) {
        List result = this.queryDslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QIssue.ISSUE.priority).distinct()).from((Expression)QIssue.ISSUE)).where((Predicate)QIssue.ISSUE.priority.isNotNull())).where((Predicate)QIssue.ISSUE.project.eq((Object)project.getId()))).fetch());
        return result.stream().map(arg_0 -> ((ConstantsManager)this.constantsManager).getPriorityObject(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<Long> findIssuesWithPriority(Project project, Priority priority) {
        return this.queryDslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).where((Predicate)QIssue.ISSUE.project.eq((Object)project.getId()))).where((Predicate)QIssue.ISSUE.priority.eq((Object)priority.getId()))).fetch());
    }

    public long countIssuesWithPriority(Project project, Priority priority) {
        return this.queryDslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).where((Predicate)QIssue.ISSUE.project.eq((Object)project.getId()))).where((Predicate)QIssue.ISSUE.priority.eq((Object)priority.getId()))).fetchCount());
    }
}

