/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.FilterCreatedEvent;
import com.atlassian.jira.event.SharedEntityUpdatedMetricsEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityCreatedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityDeletedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSearchRequestManager
implements SearchRequestManager {
    private final ColumnLayoutManager columnLayoutManager;
    private final SubscriptionManager subscriptionManager;
    private final ShareManager shareManager;
    private final SearchRequestStore searchRequestStore;
    private final SharedEntityIndexer indexer;
    private final SearchService searchService;
    private final EventPublisher eventPublisher;
    private final Resolver<IndexableSharedEntity<SearchRequest>, SharedEntity> sharedEntityPermissionsResolver = this::setSharePermissions;

    public DefaultSearchRequestManager(ColumnLayoutManager columnLayoutManager, SubscriptionManager subscriptionManager, ShareManager shareManager, SearchRequestStore searchRequestStore, SharedEntityIndexer indexer, SearchService searchService, EventPublisher eventPublisher) {
        this.columnLayoutManager = (ColumnLayoutManager)Assertions.notNull((String)"columnLayoutManager", (Object)columnLayoutManager);
        this.subscriptionManager = (SubscriptionManager)Assertions.notNull((String)"subscriptionManager", (Object)subscriptionManager);
        this.shareManager = (ShareManager)Assertions.notNull((String)"shareManager", (Object)shareManager);
        this.searchRequestStore = (SearchRequestStore)Assertions.notNull((String)"searchRequestStore", (Object)searchRequestStore);
        this.indexer = (SharedEntityIndexer)Assertions.notNull((String)"indexer", (Object)indexer);
        this.searchService = (SearchService)Assertions.notNull((String)"searchService", (Object)searchService);
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
    }

    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), this::setSharePermissions);
    }

    public EnclosedIterable<SearchRequest> get(ApplicationUser user, SharedEntityAccessor.RetrievalDescriptor descriptor) {
        final java.util.function.Function<SearchRequest, SearchRequest> transformer = this.createPermissionSanitisingResolver(user);
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), (Function)new Function<SearchRequest, SearchRequest>(){

            public SearchRequest apply(SearchRequest input) {
                return (SearchRequest)transformer.apply(input);
            }
        });
    }

    public EnclosedIterable<SearchRequest> getSearchRequests(ApplicationUser user, SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return CollectionEnclosedIterable.from((Collection)EnclosedIterable.Functions.toList(this.searchRequestStore.get(descriptor)).stream().map(this.createPermissionSanitisingResolver(user)).filter(sr -> this.isSharedWith((SearchRequest)sr, user)).collect(Collectors.toList()));
    }

    public EnclosedIterable<SearchRequest> getAll() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAll(), this::setSharePermissions);
    }

    public void visitAll(Visitor<SearchRequestEntity> visitor) {
        this.searchRequestStore.visitAll(visitor);
    }

    public EnclosedIterable<SharedEntity> getAllIndexableSharedEntities() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAllIndexableSharedEntities(), this.sharedEntityPermissionsResolver);
    }

    public Collection<SearchRequest> getAllOwnedSearchRequests(ApplicationUser user) {
        Collection<SearchRequest> searchRequests = this.searchRequestStore.getAllOwnedSearchRequests(user);
        if (searchRequests == null) {
            return Collections.emptyList();
        }
        return (Collection)searchRequests.stream().map(this.createPermissionSanitisingResolver(user)).collect(CollectorsUtil.toImmutableListWithSizeOf(searchRequests));
    }

    public SearchRequest getOwnedSearchRequestByName(ApplicationUser author, String name) {
        Assertions.notNull((String)"name", (Object)name);
        SearchRequest searchRequest = this.searchRequestStore.getRequestByAuthorAndName(author, name);
        return this.setSanitisedQuery(author, this.setSharePermissions(searchRequest));
    }

    public SearchRequest getSearchRequestById(ApplicationUser user, Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null && this.isSharedWith(searchRequest, user)) {
            return this.setSanitisedQuery(user, this.setSharePermissions(searchRequest));
        }
        return null;
    }

    public SearchRequest getSearchRequestById(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return this.setSharePermissions(searchRequest);
        }
        return null;
    }

    public List<SearchRequest> findByNameIgnoreCase(String name) {
        List<SearchRequest> searchRequests = this.searchRequestStore.findByNameIgnoreCase(name);
        for (SearchRequest searchRequest : searchRequests) {
            this.setSharePermissions(searchRequest);
        }
        return searchRequests;
    }

    public String getSearchRequestOwnerUserName(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return searchRequest.getOwner() == null ? null : searchRequest.getOwner().getUsername();
        }
        return null;
    }

    public ApplicationUser getSearchRequestOwner(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return searchRequest.getOwner();
        }
        return null;
    }

    public SearchRequest create(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        this.eventPublisher.publish((Object)FilterCreatedEvent.fromQuery(request));
        SearchRequest searchRequest = this.searchRequestStore.create(request);
        searchRequest.setPermissions(request.getPermissions());
        searchRequest.setPermissions(this.shareManager.updateSharePermissions((SharedEntity)searchRequest));
        this.eventPublisher.publish((Object)new SharedEntityCreatedEvent((SharedEntity)searchRequest));
        this.indexer.index((SharedEntity)searchRequest).await();
        return this.setSanitisedQuery(searchRequest.getOwner(), searchRequest);
    }

    public SearchRequest update(SearchRequest requestToPersist) {
        return this.update(requestToPersist.getOwner(), requestToPersist);
    }

    public SearchRequest update(ApplicationUser editor, SearchRequest requestToPersist) {
        this.validateSearchRequestUpdate(requestToPersist);
        SearchRequest oldRequest = this.searchRequestStore.getSearchRequest(requestToPersist.getId());
        oldRequest.setPermissions(this.shareManager.getSharePermissions((SharedEntity)oldRequest));
        SearchRequest persistedRequest = this.searchRequestStore.update(requestToPersist);
        persistedRequest.setPermissions(this.shareManager.updateSharePermissions((SharedEntity)requestToPersist));
        this.eventPublisher.publish((Object)new SharedEntityUpdatedEvent((SharedEntity)oldRequest, (SharedEntity)persistedRequest));
        this.eventPublisher.publish((Object)new SharedEntityUpdatedMetricsEvent(SharedEntityUpdatedMetricsEvent.SharedEntityEventType.FILTER, (SharedEntity)oldRequest, (SharedEntity)persistedRequest, editor));
        this.indexer.index((SharedEntity)persistedRequest).await();
        return this.setSanitisedQuery(editor, persistedRequest);
    }

    public void delete(Long id) {
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest((Long)Assertions.notNull((String)"id", (Object)id));
        if (searchRequest != null) {
            this.deleteSearchRequest(searchRequest);
        }
    }

    private void deleteSearchRequest(SearchRequest searchRequest) {
        try {
            CollectionUtil.foreach((Iterable)this.subscriptionManager.getAllFilterSubscriptions(searchRequest.getId()), subscription -> {
                try {
                    this.subscriptionManager.deleteSubscription(subscription.getId());
                }
                catch (Exception e) {
                    throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
        }
        try {
            if (this.columnLayoutManager.hasColumnLayout(searchRequest)) {
                this.columnLayoutManager.restoreSearchRequestColumnLayout(searchRequest);
            }
        }
        catch (ColumnLayoutStorageException e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", (Throwable)e);
        }
        this.shareManager.deletePermissions((SharedEntity)searchRequest);
        this.searchRequestStore.delete(searchRequest.getId());
        this.indexer.deIndex((SharedEntity)searchRequest).await();
        this.eventPublisher.publish((Object)new SharedEntityDeletedEvent((SharedEntity)searchRequest));
    }

    public SharedEntity.TypeDescriptor<SearchRequest> getType() {
        return SearchRequest.ENTITY_TYPE;
    }

    public void adjustFavouriteCount(SharedEntity entity, int adjustmentValue) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.equals((String)"SearchRequestManager can only adjust favourite counts for Search Requests.", (Object)SearchRequest.ENTITY_TYPE, (Object)entity.getEntityType());
        SearchRequest searchRequest = this.searchRequestStore.adjustFavouriteCount(entity.getId(), adjustmentValue);
        this.setSharePermissions(searchRequest);
        this.indexer.index((SharedEntity)searchRequest).await();
    }

    SearchRequest setSanitisedQuery(ApplicationUser searcher, SearchRequest filter) {
        Query sanitisedQuery;
        Query query;
        if (filter != null && !(query = filter.getQuery()).equals(sanitisedQuery = this.searchService.sanitiseSearchQuery(searcher, query))) {
            boolean isModified = filter.isModified();
            filter.setQuery(sanitisedQuery);
            filter.setModified(isModified);
        }
        return filter;
    }

    private boolean isSharedWith(SearchRequest entity, ApplicationUser user) {
        return this.shareManager.isSharedWith(user, (SharedEntity)entity);
    }

    private SearchRequest setSharePermissions(SearchRequest filter) {
        if (filter != null) {
            filter.setPermissions(this.shareManager.getSharePermissions((SharedEntity)filter));
        }
        return filter;
    }

    private SharedEntity setSharePermissions(IndexableSharedEntity<SearchRequest> entity) {
        if (entity != null) {
            entity.setPermissions(this.shareManager.getSharePermissions(entity));
        }
        return entity;
    }

    private void validateSearchRequestCreate(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"request.owner.user.name", request.getOwner() == null ? null : request.getOwner().getUsername());
        Assertions.notNull((String)"request.name", (Object)request.getName());
    }

    private void validateSearchRequestUpdate(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        Assertions.notNull((String)"request.id", (Object)request.getId());
    }

    public SharedEntitySearchResult<SearchRequest> search(SharedEntitySearchParameters searchParameters, ApplicationUser user, int pagePosition, int pageWidth) {
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Assertions.not((String)"pagePosition < 0", (pagePosition < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth <= 0", (pageWidth <= 0 ? 1 : 0) != 0);
        return this.indexer.withSearcher(SearchRequest.ENTITY_TYPE, searcher -> searcher.search(searchParameters, user, pagePosition, pageWidth));
    }

    public SearchRequest getSharedEntity(Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.setSharePermissions(this.searchRequestStore.getSearchRequest(entityId));
    }

    public SearchRequest getSharedEntity(ApplicationUser user, Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.getSearchRequestById(user, entityId);
    }

    public boolean hasPermissionToUse(ApplicationUser user, SearchRequest entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.equals((String)"SearchRequestManager can only adjust favourite counts for Search Requests.", (Object)SearchRequest.ENTITY_TYPE, (Object)entity.getEntityType());
        return this.shareManager.isSharedWith(user, (SharedEntity)entity);
    }

    private java.util.function.Function<SearchRequest, SearchRequest> createPermissionSanitisingResolver(ApplicationUser searcher) {
        return request -> this.setSanitisedQuery(searcher, this.setSharePermissions((SearchRequest)request));
    }

    public boolean hasShareRights(@Nullable ApplicationUser user, @Nonnull SearchRequest searchRequest, @Nonnull ShareRight shareRights) {
        ApplicationUser ownerFromStore = this.getSearchRequestOwner(searchRequest.getId());
        return ownerFromStore != null && ownerFromStore.equals((Object)searchRequest.getOwner()) && this.shareManager.isSharedWith(user, (SharedEntity)searchRequest, shareRights);
    }
}

