/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.values.IssueLinkTypesClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import webwork.action.Action;

public class IssueLinkTypesSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private static final String VIEW_TEMPLATE = "issue-linktype-searcher-view.vm";
    private static final String EDIT_TEMPLATE = "issue-linktype-searcher-edit.vm";
    private final SimpleFieldSearchConstants constants;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final IssueLinkTypesClauseValuesGenerator issueLinkTypesClauseValuesGenerator;
    private final JiraAuthenticationContext authenticationContext;

    public IssueLinkTypesSearchRenderer(SimpleFieldSearchConstants constants, VelocityRequestContextFactory velocityRequestContextFactory, FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, IssueLinkTypesClauseValuesGenerator issueLinkTypesClauseValuesGenerator, JiraAuthenticationContext authenticationContext) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, constants.getSearcherId(), searcherNameKey);
        this.constants = constants;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.issueLinkTypesClauseValuesGenerator = issueLinkTypesClauseValuesGenerator;
        this.authenticationContext = authenticationContext;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("linkTypes", this.getLinkTypes(fieldValuesHolder));
        return this.renderEditTemplate(EDIT_TEMPLATE, velocityParams);
    }

    private List<Pair<String, Boolean>> getLinkTypes(FieldValuesHolder fieldValuesHolder) {
        List<String> selectedValues = this.getSelectedValues(fieldValuesHolder);
        List<String> allValues = this.issueLinkTypesClauseValuesGenerator.getPossibleStringValues(this.authenticationContext.getLoggedInUser(), "");
        return allValues.stream().map(value -> Pair.nicePairOf((Object)value, (Object)selectedValues.contains(value))).collect(Collectors.toList());
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, user);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        List<String> values = this.getSelectedValues(fieldValuesHolder);
        velocityParams.put("selectedObjects", values);
        return this.renderViewTemplate(VIEW_TEMPLATE, velocityParams);
    }

    private List<String> getSelectedValues(FieldValuesHolder fieldValuesHolder) {
        return Optional.ofNullable((List)fieldValuesHolder.get((Object)SystemSearchConstants.forIssueLinkTypes().getUrlParameter())).orElse(Collections.emptyList());
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }
}

