/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import webwork.action.Action;

public class ProjectSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    public static final int MAX_PROJECTS_BEFORE_RECENT = 10;
    public static final int MAX_RECENT_PROJECTS_TO_SHOW = 5;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final UserProjectHistoryManager projectHistoryManager;

    public ProjectSearchRenderer(ProjectManager projectManager, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, UserProjectHistoryManager projectHistoryManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, SystemSearchConstants.forProject(), searcherNameKey);
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectHistoryManager = projectHistoryManager;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addParameters(user, fieldValuesHolder, false, velocityParams);
        return this.renderEditTemplate("project-searcher-edit.vm", velocityParams);
    }

    public void addParameters(ApplicationUser searcher, FieldValuesHolder fieldValuesHolder, boolean noCurrentSearchRequest, Map<String, Object> velocityParams) {
        Collection<Project> allProjects = this.getVisibleProjects(searcher);
        velocityParams.put("visibleProjects", allProjects);
        if (noCurrentSearchRequest && allProjects.size() == 1 && !fieldValuesHolder.containsKey((Object)SystemSearchConstants.forProject().getUrlParameter())) {
            Long singlePid = allProjects.iterator().next().getId();
            velocityParams.put("selectedProjects", Collections.singleton(Long.toString(singlePid)));
        } else {
            List projects = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter());
            if (projects != null && projects.size() == 1 && projects.get(0).equals("-1")) {
                velocityParams.put("selectedProjects", Collections.emptyList());
            } else {
                velocityParams.put("selectedProjects", projects != null ? projects : Collections.emptyList());
            }
        }
        if (allProjects.size() > 10) {
            velocityParams.put("recentProjects", this.getRecentProjects(searcher));
        }
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        List idsAsStrings = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter());
        List projectIds = ParameterUtils.makeListLong((List)idsAsStrings);
        List projects = this.projectManager.convertToProjectObjects((Collection)projectIds);
        if (projects != null) {
            ArrayList<Project> filteredOutProjects = new ArrayList<Project>(projects.size());
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                if (this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) continue;
                filteredOutProjects.add(project);
                iterator.remove();
            }
            Collections.sort(filteredOutProjects, WithId.ID_COMPARATOR);
            velocityParams.put("filteredOutProjects", filteredOutProjects);
        }
        velocityParams.put("selectedProjects", projects);
        return this.renderViewTemplate("project-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forProject().getJqlClauseNames(), query);
    }

    public Collection<Project> getRecentProjects(ApplicationUser searcher) {
        List projects = this.projectHistoryManager.getProjectHistoryWithPermissionChecks(ProjectAction.VIEW_ISSUES, searcher);
        return projects.subList(0, Math.min(5, projects.size()));
    }

    public Collection<Project> getVisibleProjects(ApplicationUser searcher) {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher);
    }
}

