/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.thumbnail;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.core.util.thumbnail.ThumbnailUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.ThumbnailConfiguration;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.thumbnail.AtlassianCoreThumbnail;
import com.atlassian.jira.issue.thumbnail.BrokenThumbnail;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Promise;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThumbnailManager
implements ThumbnailManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultThumbnailManager.class);
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private final AttachmentManager attachmentManager;
    private final AttachmentStore attachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;
    private final MimeManager mimeManager;
    private final ThumbnailConfiguration thumbnailConfig;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final boolean toolkitAvailable;

    public DefaultThumbnailManager(ThumbnailConfiguration thumbnailConfiguration, AttachmentManager attachmentManager, MimeManager mimeManager, VelocityRequestContextFactory velocityRequestContextFactory, AttachmentStore attachmentStore, ThumbnailAccessor thumbnailAccessor, ApplicationProperties applicationProperties) {
        this.attachmentManager = attachmentManager;
        this.attachmentStore = attachmentStore;
        this.thumbnailAccessor = thumbnailAccessor;
        this.mimeManager = mimeManager;
        this.thumbnailConfig = thumbnailConfiguration;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.toolkitAvailable = Toolkit.getDefaultToolkit() != null;
    }

    public Collection<Thumbnail> getThumbnails(Issue issue, ApplicationUser user) {
        List attachments = this.attachmentManager.getAttachments(issue);
        ArrayList thumbnails = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Attachment attachment : attachments) {
            if (!this.isThumbnailable(issue, attachment)) continue;
            thumbnails.add(this.doGetThumbnail(issue, attachment));
        }
        return thumbnails;
    }

    public boolean isThumbnailable(Issue issue, Attachment attachment) {
        if (attachment.isThumbnailable() != null) {
            return attachment.isThumbnailable();
        }
        if (!this.checkToolkit()) {
            return false;
        }
        Promise isSupportedImage = this.attachmentStore.getAttachment(attachment, (Function)new Function<InputStream, Boolean>(){

            @Override
            public Boolean apply(InputStream input) {
                return new Thumber(ThumbnailManager.MIME_TYPE).isFileSupportedImage(input);
            }
        }).recover(t -> false);
        boolean thumbnailable = false;
        if (((Boolean)isSupportedImage.claim()).booleanValue()) {
            String mimeType = this.mimeManager.getSuggestedMimeType(attachment.getFilename());
            thumbnailable = ThumbnailUtil.isMimeTypeSupported((String)mimeType);
        }
        this.attachmentManager.setThumbnailable(attachment, thumbnailable);
        return thumbnailable;
    }

    public boolean isThumbnailable(Attachment attachment) {
        return this.isThumbnailable(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Attachment attachment) {
        return this.getThumbnail(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Issue issue, Attachment attachment) {
        if (!this.isThumbnailable(issue, attachment)) {
            return null;
        }
        return this.doGetThumbnail(issue, attachment);
    }

    public boolean checkToolkit() {
        return this.toolkitAvailable;
    }

    public ThumbnailedImage toThumbnailedImage(@Nullable Thumbnail thumbnail) {
        if (thumbnail == null) {
            return null;
        }
        return new AtlassianCoreThumbnail(this.applicationProperties, this.velocityRequestContextFactory.getJiraVelocityRequestContext(), thumbnail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T streamThumbnailContent(Attachment attachment, InputStreamConsumer<T> consumer) throws IOException {
        File thumbnailFile = this.thumbnailAccessor.getThumbnailFile(attachment);
        InputStream inputStream = new FileInputStream(thumbnailFile);
        try {
            inputStream = new BufferedInputStream(inputStream);
            Object object = consumer.withInputStream(inputStream);
            return (T)object;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private Thumbnail doGetThumbnail(Issue issue, Attachment attachment) {
        File thumbnailFile = this.getThumbnailFile(issue, attachment);
        Thumbnail existingThumbnail = this.readThumbnail(attachment, thumbnailFile);
        if (existingThumbnail != null) {
            return existingThumbnail;
        }
        File tempThumbnailFile = DefaultThumbnailManager.getTempFile(thumbnailFile);
        int scalingFactor = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.thumbnails.scaling.factor"));
        Thumbnail thumbnail = this.createThumbnail(attachment, tempThumbnailFile, this.thumbnailConfig.getMaxWidth(), this.thumbnailConfig.getMaxHeight(), scalingFactor);
        if (thumbnail instanceof BrokenThumbnail) {
            return thumbnail;
        }
        if (thumbnailFile.exists()) {
            FileUtils.deleteQuietly((File)tempThumbnailFile);
        } else {
            boolean renamed = tempThumbnailFile.renameTo(thumbnailFile);
            if (!renamed || !thumbnailFile.exists()) {
                log.debug("Could not rename '{}' to '{}'", (Object)tempThumbnailFile.getAbsolutePath(), (Object)thumbnailFile.getAbsolutePath());
                return new BrokenThumbnail(attachment.getId());
            }
        }
        return new Thumbnail(thumbnail.getHeight(), thumbnail.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), thumbnail.getMimeType());
    }

    private File getThumbnailFile(@Nullable Issue issue, Attachment attachment) {
        return issue == null ? this.thumbnailAccessor.getThumbnailFile(attachment) : this.thumbnailAccessor.getThumbnailFile(issue, attachment);
    }

    private Thumbnail createThumbnail(Attachment attachment, File thumbnailFile, int maxWidth, int maxHeight, int scalingFactor) {
        try {
            FileUtils.touch((File)thumbnailFile);
            FileUtils.deleteQuietly((File)thumbnailFile);
            return (Thumbnail)this.attachmentManager.streamAttachmentContent(attachment, in -> {
                Thumbnail thumbnail = new Thumber(MIME_TYPE, scalingFactor).retrieveOrCreateThumbNail(in, attachment.getFilename(), thumbnailFile, maxWidth, maxHeight, attachment.getId().longValue());
                if (thumbnail == null) {
                    return null;
                }
                if (thumbnail.getFilename() != null && thumbnailFile.getName().equals(thumbnail.getFilename())) {
                    return thumbnail;
                }
                return new Thumbnail(thumbnail.getHeight(), thumbnail.getWidth(), thumbnailFile.getName(), thumbnail.getAttachmentId(), thumbnail.getMimeType());
            });
        }
        catch (Exception e) {
            log.warn("Unable to create thumbnail {} for image {} id: {}, found in issue {}. Resetting thumbnailable flag to FALSE ", new Object[]{thumbnailFile.getAbsolutePath(), attachment.getFilename(), attachment.getId(), attachment.getIssue().getKey(), e});
            this.attachmentManager.setThumbnailable(attachment, false);
            return new BrokenThumbnail(attachment.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thumbnail readThumbnail(@Nonnull Attachment attachment, @Nonnull File thumbnailFile) {
        if (thumbnailFile.exists()) {
            Thumbnail thumbnail;
            log.debug("Thumbnail file '{}' already exists. Returning existing thumbnail.", (Object)thumbnailFile);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(thumbnailFile);
                ThumbnailDimension thumbnailDimension = ThumbnailUtil.dimensionsForImage((InputStream)inputStream);
                thumbnail = new Thumbnail(thumbnailDimension.getHeight(), thumbnailDimension.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), MIME_TYPE);
            }
            catch (IOException asd) {
                try {
                    log.debug("Unable to read image data from existing thumbnail file '{}'. Deleting this thumbnail.", (Object)thumbnailFile);
                    FileUtils.deleteQuietly((File)thumbnailFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return thumbnail;
        }
        return null;
    }

    public void deleteThumbnailForAttachment(@Nullable Issue issue, Attachment attachment) {
        File thumbnailFile;
        if (this.isThumbnailable(issue, attachment) && (thumbnailFile = this.getThumbnailFile(issue, attachment)).exists() && !thumbnailFile.delete()) {
            log.debug("Unable to delete thumbnail for attachment {}", (Object)attachment.getId());
        }
    }

    public void deleteThumbnailsForIssue(@Nonnull Issue issue) {
        for (Attachment attachment : this.attachmentManager.getAttachments(issue)) {
            this.deleteThumbnailForAttachment(issue, attachment);
        }
        File thumbnailDirectory = this.thumbnailAccessor.getThumbnailDirectory(issue);
        if (thumbnailDirectory.exists() && !thumbnailDirectory.delete()) {
            log.debug("Unable to delete thumbnail directory of issue {}", (Object)issue.getKey());
        }
    }

    private static File getTempFile(File thumbnailFile) {
        try {
            return File.createTempFile(thumbnailFile.getName(), TEMP_FILE_SUFFIX, thumbnailFile.getParentFile());
        }
        catch (IOException unableToCreateFile) {
            throw new IllegalStateException(unableToCreateFile);
        }
    }
}

