/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.transitions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

public class TransitionLinkFactory
implements WebItemProvider {
    private final VelocityRequestContextFactory requestContextFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private final JiraAuthenticationContext authenticationContext;

    public TransitionLinkFactory(VelocityRequestContextFactory requestContextFactory, IssueWorkflowManager issueWorkflowManager, JiraAuthenticationContext authenticationContext) {
        this.requestContextFactory = requestContextFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.authenticationContext = authenticationContext;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        return this.getAvailableActions(issue);
    }

    private List<WebItem> getAvailableActions(Issue issue) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        List actions = this.issueWorkflowManager.getSortedAvailableActions(issue, this.authenticationContext.getUser());
        ArrayList<WebItem> returnList = new ArrayList<WebItem>(actions.size());
        int weight = 0;
        for (ActionDescriptor action : actions) {
            String url = requestContext.getBaseUrl() + "/secure/WorkflowUIDispatcher.jspa?id=" + issue.getId() + "&action=" + action.getId() + "&atl_token=" + this.getXsrfToken();
            String transitionDisplayName = this.getWorkflowTransitionDisplayName(action);
            String description = this.getWorkflowTransitionDescription(action);
            returnList.add(new WebFragmentBuilder(weight += 10).styleClass("issueaction-workflow-transition").id("action_id_" + action.getId()).label(transitionDisplayName).title(StringUtils.isBlank((CharSequence)description) ? null : transitionDisplayName + " - " + description).webItem("transitions-all").url(url).build());
        }
        return returnList;
    }

    String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        return WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)descriptor);
    }

    String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return StringUtils.trimToNull((String)WorkflowUtil.getWorkflowTransitionDescription((ActionDescriptor)descriptor));
    }

    String getXsrfToken() {
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null) {
            return this.getXsrfTokenGenerator().generateToken(request);
        }
        return "";
    }

    XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
    }
}

