/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.util.IssueIterator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.GenericValue;

class DatabaseIssuesIterator
implements IssueIterator {
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;
    private final EntityCondition condition;
    private final ImmutableList<String> orderBy;
    private final EntityFindOptions findOptions;
    private OfBizListIterator issuesIterator;
    private Issue nextIssue;

    DatabaseIssuesIterator(OfBizDelegator delegator, IssueFactory issueFactory) {
        this(delegator, issueFactory, null);
    }

    DatabaseIssuesIterator(OfBizDelegator delegator, IssueFactory issueFactory, @Nullable EntityCondition condition) {
        this(delegator, issueFactory, condition, null, null);
    }

    DatabaseIssuesIterator(OfBizDelegator delegator, IssueFactory issueFactory, @Nullable EntityCondition condition, @Nullable List<String> orderBy, @Nullable EntityFindOptions findOptions) {
        this.delegator = delegator;
        this.issueFactory = issueFactory;
        this.orderBy = orderBy != null ? ImmutableList.copyOf(orderBy) : null;
        this.condition = condition;
        this.findOptions = findOptions;
    }

    @Override
    public boolean hasNext() {
        this.populateNextIssueIfNull();
        return this.nextIssue != null;
    }

    @Override
    public Issue next() {
        this.populateNextIssueIfNull();
        if (this.nextIssue == null) {
            throw new NoSuchElementException();
        }
        Issue issue = this.nextIssue;
        this.nextIssue = null;
        return issue;
    }

    private void populateNextIssueIfNull() {
        if (this.nextIssue == null) {
            this.pullNextIssue();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove an issue from an Issue Iterator");
    }

    @Override
    @Deprecated
    public Issue nextIssue() {
        return this.next();
    }

    @Override
    public void close() {
        if (this.issuesIterator != null) {
            this.issuesIterator.close();
        }
    }

    public OfBizListIterator getIssuesIterator() {
        if (this.issuesIterator == null) {
            this.issuesIterator = this.delegator.findListIteratorByCondition("Issue", this.condition, null, null, this.orderBy, this.findOptions);
        }
        return this.issuesIterator;
    }

    private void pullNextIssue() {
        GenericValue issueGV = this.getIssuesIterator().next();
        if (issueGV == null) {
            return;
        }
        this.nextIssue = this.issueFactory.getIssue(issueGV);
    }
}

