/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.mail.BotoCssInliner;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BotocssThreadLauncher
implements Startable {
    private final EventPublisher eventPublisher;
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();

    public BotocssThreadLauncher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onComponentManagerStarted(ComponentManagerStartedEvent startedEvent) {
        ScheduledExecutorService e = Executors.newSingleThreadScheduledExecutor(ThreadFactories.named((String)"jira-botocss").type(ThreadFactories.Type.DAEMON).build());
        long cleanupSecs = 15L;
        e.scheduleWithFixedDelay(new CacheCleaner(), cleanupSecs, cleanupSecs, TimeUnit.SECONDS);
        this.executor.set(e);
    }

    @EventListener
    public void onComponentManagerShutdown(ComponentManagerShutdownEvent shutdownEvent) {
        ScheduledExecutorService e = this.executor.getAndSet(null);
        if (e != null) {
            e.shutdown();
        }
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        @Override
        public void run() {
            BotoCssInliner botocssInliner = (BotoCssInliner)ComponentAccessor.getComponent(BotoCssInliner.class);
            if (botocssInliner != null) {
                botocssInliner.performCacheMaintenance();
            }
        }
    }
}

