/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.mention.MentionableUserSearcher;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.ImmutableUserIssueRelevance;
import com.atlassian.jira.user.IssueInvolvement;
import com.atlassian.jira.user.UserIssueRelevance;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SortedMentionableUserSearcher
implements MentionableUserSearcher {
    private static final Date EPOCH = new Date(0L);
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;
    private final CommentService commentService;
    private final WatcherService watcherService;
    private final VoteService voteService;
    private final UserSearchService userSearchService;

    public SortedMentionableUserSearcher(I18nHelper i18n, PermissionManager permissionManager, CommentService commentService, WatcherService watcherService, VoteService voteService, UserSearchService userSearchService) {
        this.permissionManager = permissionManager;
        this.commentService = commentService;
        this.watcherService = watcherService;
        this.voteService = voteService;
        this.userSearchService = userSearchService;
        this.i18n = (I18nHelper)Assertions.notNull((Object)i18n);
    }

    @Override
    public List<UserIssueRelevance> findRelatedUsersToMention(String query, Issue issue, ApplicationUser requestingUser, int maxResults) {
        if (issue == null || !this.permissionManager.hasPermission(27, requestingUser)) {
            return ImmutableList.of();
        }
        String lowercaseQuery = StringUtils.isEmpty((CharSequence)query) ? "" : query.toLowerCase(this.i18n.getLocale());
        List visibleComments = this.commentService.getCommentsForUser(requestingUser, issue).stream().filter(comment -> comment.getAuthorApplicationUser() != null).collect(Collectors.toList());
        Optional<ApplicationUser> assignee = Optional.ofNullable(issue.getAssignee());
        Optional<ApplicationUser> reporter = Optional.ofNullable(issue.getReporter());
        List<ApplicationUser> usersFromRoleMention = this.getUsersFromRoleMention(lowercaseQuery, assignee, reporter);
        Map<ApplicationUser, Date> userLatestCommentDates = visibleComments.stream().collect(Collectors.groupingBy(Comment::getAuthorApplicationUser, Collectors.reducing(EPOCH, Comment::getCreated, BinaryOperator.maxBy(Comparator.naturalOrder()))));
        List<ApplicationUser> watchers = this.getWatchers(requestingUser, issue);
        List<ApplicationUser> voters = this.getVoters(requestingUser, issue);
        HashSet<ApplicationUser> involvedUsers = new HashSet<ApplicationUser>();
        assignee.ifPresent(involvedUsers::add);
        reporter.ifPresent(involvedUsers::add);
        involvedUsers.addAll(userLatestCommentDates.keySet());
        involvedUsers.addAll(watchers);
        involvedUsers.addAll(voters);
        List filteredInvolvedUsers = involvedUsers.stream().filter(new UserMatcherPredicate(lowercaseQuery, false)::apply).collect(Collectors.toList());
        HashSet<ApplicationUser> matchingUsers = new HashSet<ApplicationUser>();
        matchingUsers.addAll(usersFromRoleMention);
        matchingUsers.addAll(filteredInvolvedUsers);
        if (matchingUsers.size() < maxResults) {
            List<ApplicationUser> usersFromSearch = this.searchForUsers(lowercaseQuery, issue, maxResults);
            matchingUsers.addAll(usersFromSearch);
        }
        return this.getUserIssueRelevances(matchingUsers, issue, assignee, reporter, userLatestCommentDates, voters, watchers, maxResults);
    }

    private List<UserIssueRelevance> getUserIssueRelevances(Set<ApplicationUser> matchingUsers, Issue issue, Optional<ApplicationUser> assignee, Optional<ApplicationUser> reporter, Map<ApplicationUser, Date> userLatestCommentDates, List<ApplicationUser> voters, List<ApplicationUser> watchers, int maxResults) {
        HashSet<ApplicationUser> watcherSet = new HashSet<ApplicationUser>(watchers);
        HashSet<ApplicationUser> voterSet = new HashSet<ApplicationUser>(voters);
        return matchingUsers.stream().map(user -> this.buildUserIssuerRelevance((ApplicationUser)user, issue, assignee, reporter, userLatestCommentDates, (Set<ApplicationUser>)watcherSet, (Set<ApplicationUser>)voterSet)).sorted().limit(maxResults).collect(Collectors.toList());
    }

    private List<ApplicationUser> getUsersFromRoleMention(String lowercaseQuery, Optional<ApplicationUser> assignee, Optional<ApplicationUser> reporter) {
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(2);
        if (this.queryMatchesInvolvement(lowercaseQuery, IssueInvolvement.REPORTER)) {
            reporter.ifPresent(users::add);
        }
        if (this.queryMatchesInvolvement(lowercaseQuery, IssueInvolvement.ASSIGNEE)) {
            assignee.ifPresent(users::add);
        }
        return users;
    }

    private boolean queryMatchesInvolvement(String lowercaseQuery, IssueInvolvement involvement) {
        return this.i18n.getText(involvement.getI18nKey()).toLowerCase(this.i18n.getLocale()).startsWith(lowercaseQuery);
    }

    private List<ApplicationUser> getVoters(ApplicationUser requestingUser, Issue issue) {
        ServiceOutcome voters = this.voteService.viewVoters(issue, requestingUser);
        return voters.isValid() ? ImmutableList.copyOf((Collection)((Collection)voters.getReturnedValue())) : ImmutableList.of();
    }

    private List<ApplicationUser> getWatchers(ApplicationUser requestingUser, Issue issue) {
        ServiceOutcome watchers;
        if (this.watcherService.isWatchingEnabled() && (watchers = this.watcherService.getWatchers(issue, requestingUser)).isValid()) {
            return (List)((Pair)watchers.getReturnedValue()).second();
        }
        return ImmutableList.of();
    }

    private UserIssueRelevance buildUserIssuerRelevance(ApplicationUser user, Issue issue, Optional<ApplicationUser> assignee, Optional<ApplicationUser> reporter, Map<ApplicationUser, Date> userLatestCommentDates, Set<ApplicationUser> watchers, Set<ApplicationUser> voters) {
        ImmutableUserIssueRelevance.IssueUserBuilder issueUserBuilder = new ImmutableUserIssueRelevance.IssueUserBuilder().withIssue(issue).withUser(user);
        if (assignee.map(arg_0 -> ((ApplicationUser)user).equals(arg_0)).orElse(false).booleanValue()) {
            issueUserBuilder.withAssigneeInvolvement();
        }
        if (reporter.map(arg_0 -> ((ApplicationUser)user).equals(arg_0)).orElse(false).booleanValue()) {
            issueUserBuilder.withReporterInvolvement();
        }
        Optional.ofNullable(userLatestCommentDates.get(user)).ifPresent(issueUserBuilder::withCommenterInvolvement);
        if (watchers.contains(user)) {
            issueUserBuilder.withWatcherInvolvement();
        }
        if (voters.contains(user)) {
            issueUserBuilder.withVoterInvolvement();
        }
        return issueUserBuilder.build();
    }

    private List<ApplicationUser> searchForUsers(String lowercaseQuery, Issue issue, int maxResults) {
        Predicate<User> hasIssueBrowsePermission = user -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, ApplicationUsers.from(user));
        UserSearchParams anyActiveUser = UserSearchParams.builder().allowEmptyQuery(true).filter(hasIssueBrowsePermission::test).maxResults(Integer.valueOf(maxResults)).build();
        return this.userSearchService.findUsers(lowercaseQuery, anyActiveUser);
    }
}

