/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.plugin.BootstrapPluginDirectoryLoaderFactory;
import com.atlassian.jira.plugin.PluginFactoryAndLoaderRegistrar;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class BootstrapPluginLoaderFactory
implements PluginLoaderFactory {
    private static final Logger log = LoggerFactory.getLogger(BootstrapPluginLoaderFactory.class);
    @VisibleForTesting
    static final List<Pattern> PLUGIN_WHITELIST = ImmutableList.of((Object)Pattern.compile("atlassian-frontend-runtime-plugin-.*\\.jar"), (Object)Pattern.compile("jira-webresources-plugin-.*\\.jar"), (Object)Pattern.compile("jquery-[0-9]+(?:\\.[0-9])+\\.jar"), (Object)Pattern.compile("auiplugin-[0-9.]+.*\\.jar"), (Object)Pattern.compile("jira-ui-[0-9.]+.*\\.jar"), (Object)Pattern.compile("jira-(?:core-)?language-pack-.*\\.jar"), (Object)Pattern.compile("jira-languages-.*\\.jar"), (Object)Pattern.compile("org.apache.servicemix.bundles.javax-inject-.*\\.jar"), (Object)Pattern.compile("soy-template-plugin-.*\\.jar"), (Object)Pattern.compile("issue-status-plugin-.*\\.jar"), (Object)Pattern.compile("less-transformer-plugin-.*\\.jar"), (Object)Pattern.compile("jira-less-integration-.*\\.jar"), (Object[])new Pattern[]{Pattern.compile("jslibs-.*\\.jar")});
    private final PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar;
    private final BootstrapPluginDirectoryLoaderFactory bootstrapPluginDirectoryLoaderFactory;

    public BootstrapPluginLoaderFactory(PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar, BootstrapPluginDirectoryLoaderFactory bootstrapPluginDirectoryLoaderFactory) {
        this.pluginFactoryAndLoaderRegistrar = Objects.requireNonNull(pluginFactoryAndLoaderRegistrar);
        this.bootstrapPluginDirectoryLoaderFactory = Objects.requireNonNull(bootstrapPluginDirectoryLoaderFactory);
    }

    @Override
    public List<PluginLoader> getPluginLoaders() {
        List<PluginFactory> pluginFactories = this.pluginFactoryAndLoaderRegistrar.getDefaultPluginFactories(PLUGIN_WHITELIST);
        CollectionBuilder pluginLoaderBuilder = CollectionBuilder.newBuilder();
        pluginLoaderBuilder.addAll(this.pluginFactoryAndLoaderRegistrar.getBootstrapSystemPluginLoaders());
        if (JiraSystemProperties.getInstance().isBundledPluginsDisabled()) {
            log.warn("Bundled plugins have been disabled. Removing bundled plugin loader.");
        } else {
            pluginLoaderBuilder.add((Object)this.pluginFactoryAndLoaderRegistrar.getBundledPluginsLoader(pluginFactories));
        }
        pluginLoaderBuilder.add((Object)this.bootstrapPluginDirectoryLoaderFactory.getDirectoryPluginLoader(pluginFactories));
        return pluginLoaderBuilder.asList();
    }
}

