/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldTypeCategory;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldDefaultVelocityParams;
import com.atlassian.jira.plugin.customfield.CustomFieldRestSerializer;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.workflow.JiraWorkflowPluginConstants;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.extras.ImmutableMaps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import webwork.action.Action;

public class CustomFieldTypeModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<CustomFieldType>
implements CustomFieldTypeModuleDescriptor {
    public static final String REST_SERIALIZER_ELEMENT_NAME = "rest-serializer";
    public static final String VERSION_NUMBER_ARGUMENT_NAME = "version-number";
    public static final String SERIALIZER_CLASS_ARGUMENT_NAME = "class";
    private final CustomFieldDefaultVelocityParams customFieldDefaultVelocityParams;
    private RendererManager rendererManager;
    private Set<String> validSearcherKeys;
    private Set<CustomFieldTypeCategory> categories;
    private ConfigurationItemAccessLevel managedAccessLevel = null;
    private String managedDescriptionKey;
    private Map<Integer, String> restSerializerClassNames;
    private Map<Integer, CustomFieldRestSerializer> restSerializers;

    public CustomFieldTypeModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, RendererManager rendererManager, ModuleFactory moduleFactory, CustomFieldDefaultVelocityParams customFieldDefaultVelocityParams) {
        super(authenticationContext, moduleFactory);
        this.rendererManager = rendererManager;
        this.customFieldDefaultVelocityParams = customFieldDefaultVelocityParams;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.managedAccessLevel = this.readManagedAccessLevel(element);
        if (this.managedAccessLevel != null) {
            this.managedDescriptionKey = this.readManagedDescriptionKey(element);
        }
        this.validSearcherKeys = this.readValidSearcherKeys(element);
        this.categories = this.deduceCategories(this.readCategories(element));
        this.restSerializerClassNames = this.readRestSerializerClassNames(element);
    }

    public Set<String> getValidSearcherKeys() {
        return this.validSearcherKeys;
    }

    public Set<CustomFieldTypeCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(CustomFieldType.class);
        this.loadExtraRestSerializerClasses();
    }

    private void loadExtraRestSerializerClasses() {
        this.restSerializers = ImmutableMap.copyOf((Map)Maps.transformValues(this.restSerializerClassNames, (Function)new Function<String, CustomFieldRestSerializer>(){

            public CustomFieldRestSerializer apply(String className) {
                return (CustomFieldRestSerializer)CustomFieldTypeModuleDescriptorImpl.this.getObjectFromClassName(className, CustomFieldRestSerializer.class);
            }
        }));
    }

    private <T> T getObjectFromClassName(String className, Class<T> castClass) {
        if (!(this.plugin instanceof ContainerManagedPlugin)) {
            throw new IllegalStateException("Plugin object has to implement a ContainerManagedPlugin interface.");
        }
        try {
            Class clazz = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
            Object bean = ((ContainerManagedPlugin)this.plugin).getContainerAccessor().createBean(clazz);
            return castClass.cast(bean);
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Error finding object descriptor class:" + className, (Throwable)e);
        }
    }

    public boolean isViewTemplateExists() {
        return this.isResourceExist("view");
    }

    public boolean isColumnViewTemplateExists() {
        return this.isResourceExist("column-view");
    }

    public boolean isEditTemplateExists() {
        return this.isResourceExist("edit");
    }

    public boolean isXMLTemplateExists() {
        return this.isResourceExist("xml");
    }

    public boolean isTypeManaged() {
        return this.managedAccessLevel != null;
    }

    @Nullable
    public ConfigurationItemAccessLevel getManagedAccessLevel() {
        return this.managedAccessLevel;
    }

    public String getManagedDescriptionKey() {
        return this.isTypeManaged() ? this.managedDescriptionKey : null;
    }

    public String getEditHtml(final FieldConfig config, final Map customFieldValuesHolder, final Issue issue, final Action action, final Map displayParameters, final FieldLayoutItem fieldLayoutItem) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                Assertions.notNull((String)"config", (Object)config);
                Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
                return CustomFieldTypeModuleDescriptorImpl.this.getHtml("edit", params);
            }
        });
    }

    public String getBulkMoveHtml(final FieldConfig config, final Map customFieldValuesHolder, final Issue issue, final Action action, final Map displayParameters, final FieldLayoutItem fieldLayoutItem, final Map<Long, BulkMoveHelper.DistinctValueResult> distinctValues, final BulkMoveHelper bulkMoveHelper) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                Assertions.notNull((String)"config", (Object)config);
                Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
                params.put("valuesToMap", distinctValues);
                params.put("bulkMoveHelper", bulkMoveHelper);
                String html = CustomFieldTypeModuleDescriptorImpl.this.getResourceDescriptor(JiraWorkflowPluginConstants.RESOURCE_TYPE_VELOCITY, "bulk-move") != null ? CustomFieldTypeModuleDescriptorImpl.this.getHtml("bulk-move", params) : CustomFieldTypeModuleDescriptorImpl.this.getHtml("edit", params);
                return html;
            }
        });
    }

    public String getEditDefaultHtml(final FieldConfig config, final Map customFieldValuesHolder, final Issue issue, final Action action, final Map displayParameters, final FieldLayoutItem fieldLayoutItem) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                Assertions.notNull((String)"config", (Object)config);
                Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
                String html = CustomFieldTypeModuleDescriptorImpl.this.getResourceDescriptor(JiraWorkflowPluginConstants.RESOURCE_TYPE_VELOCITY, "edit-default") != null ? CustomFieldTypeModuleDescriptorImpl.this.getHtml("edit-default", params) : CustomFieldTypeModuleDescriptorImpl.this.getHtml("edit", params);
                return html;
            }
        });
    }

    public String getColumnViewHtml(final CustomField field, final Object value, final Issue issue, final Map displayParams, final FieldLayoutItem fieldLayoutItem) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                if (CustomFieldTypeModuleDescriptorImpl.this.isResourceExist("column-view")) {
                    return CustomFieldTypeModuleDescriptorImpl.this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "column-view", displayParams);
                }
                return CustomFieldTypeModuleDescriptorImpl.this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParams);
            }
        });
    }

    public String getViewHtml(CustomField field, Object value, Issue issue, FieldLayoutItem fieldLayoutItem) {
        return this.getViewHtml(field, value, issue, fieldLayoutItem, null);
    }

    public String getViewHtml(final CustomField field, final Object value, final Issue issue, final FieldLayoutItem fieldLayoutItem, final Map displayParameters) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                return CustomFieldTypeModuleDescriptorImpl.this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParameters);
            }
        });
    }

    public String getViewXML(final CustomField field, final Issue issue, final FieldLayoutItem fieldLayoutItem, final boolean raw) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                Map combinedMap = CustomFieldTypeModuleDescriptorImpl.this.getCombinedMap(field.getCustomFieldType().getVelocityParameters(issue, field, fieldLayoutItem), MapBuilder.build((Object)"value", (Object)field.getValue(issue)));
                if (field.isRenderable() && !raw) {
                    String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
                    combinedMap.put("renderedValue", CustomFieldTypeModuleDescriptorImpl.this.rendererManager.getRenderedContent(rendererType, (String)field.getValue(issue), issue.getIssueRenderContext()));
                }
                return CustomFieldTypeModuleDescriptorImpl.this.getHtml("xml", combinedMap);
            }
        });
    }

    public String getDefaultViewHtml(final FieldConfig fieldConfig, final FieldLayoutItem fieldLayoutItem) {
        return this.getSupplierValueOrHtmlErrorMessage(new Callable<String>(){

            @Override
            public String call() {
                CustomField customField = fieldConfig.getCustomField();
                Object value = customField.getCustomFieldType().getDefaultValue(fieldConfig);
                if (customField.isRenderable()) {
                    String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
                    return CustomFieldTypeModuleDescriptorImpl.this.rendererManager.getRenderedContent(rendererType, (String)value, null);
                }
                return CustomFieldTypeModuleDescriptorImpl.this.getViewHtmlByValue(fieldLayoutItem, value, customField, null, "view", null);
            }
        });
    }

    private String getViewHtmlByValue(FieldLayoutItem fieldLayoutItem, Object value, CustomField field, Issue issue, String templateNameView, Map displayParams) {
        Map params = CustomFieldUtils.buildParams((CustomField)field, null, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, (Object)value, null, null, (Map)displayParams);
        return this.getHtml(templateNameView, params);
    }

    @Override
    public String getHtml(String resourceName, Map<String, ?> startingParams) {
        try {
            return super.getHtml(resourceName, this.customFieldDefaultVelocityParams.combine(startingParams));
        }
        catch (Throwable throwable) {
            SafePluginPointAccess.handleException((Throwable)throwable);
            return this.getHtmlErrorMessage();
        }
    }

    public Map<Integer, CustomFieldRestSerializer> getRestSerializers() {
        return this.restSerializers;
    }

    private Map<String, Object> getCombinedMap(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (map1 != null) {
            allParams.putAll(map1);
        }
        if (map2 != null) {
            allParams.putAll(map2);
        }
        return allParams;
    }

    @VisibleForTesting
    Set<CustomFieldTypeCategory> deduceCategories(Set<String> candidates) {
        EnumSet<CustomFieldTypeCategory> categories = EnumSet.noneOf(CustomFieldTypeCategory.class);
        for (String candidate : candidates) {
            Optional category = CustomFieldTypeCategory.fromString((String)candidate);
            if (!category.isPresent()) continue;
            categories.add((CustomFieldTypeCategory)category.get());
        }
        categories.remove(CustomFieldTypeCategory.ALL);
        if (categories.isEmpty()) {
            categories.add(CustomFieldTypeCategory.ADVANCED);
        }
        categories.add(CustomFieldTypeCategory.ALL);
        return Collections.unmodifiableSet(categories);
    }

    private String getSupplierValueOrHtmlErrorMessage(Callable<String> callable) {
        com.google.common.base.Supplier<String> errorMessageSupplier = new com.google.common.base.Supplier<String>(){

            public String get() {
                return CustomFieldTypeModuleDescriptorImpl.this.getHtmlErrorMessage();
            }
        };
        return (String)SafePluginPointAccess.call(callable).getOrElse((Supplier)errorMessageSupplier);
    }

    private String getHtmlErrorMessage() {
        return this.getAuthenticationContext().getI18nHelper().getText("modulewebcomponent.exception", this.getKey());
    }

    private ConfigurationItemAccessLevel readManagedAccessLevel(Element element) {
        Attribute managedAccessLevel = element.attribute("managed-access-level");
        if (managedAccessLevel == null || StringUtils.isBlank((CharSequence)managedAccessLevel.getValue())) {
            return null;
        }
        try {
            return ConfigurationItemAccessLevel.valueOf((String)managedAccessLevel.getValue().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String readManagedDescriptionKey(Element element) {
        Attribute managedDesc = element.attribute("managed-description-key");
        if (managedDesc == null || StringUtils.isBlank((CharSequence)managedDesc.getValue())) {
            return "admin.managed.configuration.items.customfieldtype.description";
        }
        return managedDesc.getValue();
    }

    private Set<String> readCategories(Element element) {
        return this.readSetFromElement(element, "category", new Function<Element, String>(){

            public String apply(Element categoryElement) {
                return categoryElement.getTextTrim();
            }
        });
    }

    private Set<String> readValidSearcherKeys(Element element) {
        return this.readSetFromElement(element, "valid-searcher", new Function<Element, String>(){

            public String apply(Element searcherElement) {
                String packageName = searcherElement.attributeValue("package");
                String key = searcherElement.attributeValue("key");
                return packageName + ":" + key;
            }
        });
    }

    private Set<String> readSetFromElement(Element element, String name, Function<Element, String> transformation) {
        List elements = element.elements(name);
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)elements, transformation));
    }

    private Map<Integer, String> readRestSerializerClassNames(Element element) {
        List restSerializerElements = element.elements(REST_SERIALIZER_ELEMENT_NAME);
        Iterable entries = Iterables.transform((Iterable)restSerializerElements, (Function)new Function<Element, Map.Entry<Integer, String>>(){

            public Map.Entry<Integer, String> apply(@Nullable Element element) {
                Integer version = CustomFieldTypeModuleDescriptorImpl.this.parseVersionNumber(CustomFieldTypeModuleDescriptorImpl.this.getRequiredAttributeValue(element, CustomFieldTypeModuleDescriptorImpl.VERSION_NUMBER_ARGUMENT_NAME));
                String className = CustomFieldTypeModuleDescriptorImpl.this.getRequiredAttributeValue(element, CustomFieldTypeModuleDescriptorImpl.SERIALIZER_CLASS_ARGUMENT_NAME);
                return Maps.immutableEntry((Object)version, (Object)className);
            }
        });
        try {
            return ImmutableMaps.toMap((Iterable)entries);
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("rest-serializer's version-number can't be duplicated", (Throwable)e);
        }
    }

    private Integer parseVersionNumber(String versionStr) {
        try {
            int version = Integer.parseInt(versionStr);
            if (version < 2) {
                throw this.getParseVersionNumberException();
            }
            return version;
        }
        catch (NumberFormatException e) {
            throw this.getParseVersionNumberException();
        }
    }

    private PluginParseException getParseVersionNumberException() {
        return new PluginParseException("rest-serializer's version-number argument has to be an integer greater or equal 2.");
    }

    private String getRequiredAttributeValue(Element element, String name) {
        String value = element.attributeValue(name);
        if (value == null) {
            throw new PluginParseException("rest-serializer requires " + name + " argument");
        }
        return value;
    }
}

