/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFilenames;
import com.atlassian.jira.plugin.icon.SystemIconImageProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSystemIconImageProvider
implements SystemIconImageProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemIconImageProvider.class);
    private static final String ICON_CLASSPATH_PREFIX = "/avatars/";

    @Nonnull
    public InputStream getSystemIconInputStream(Avatar icon, Avatar.Size size) throws IOException {
        String path = this.getIconPath(icon, size);
        InputStream data = this.getClass().getResourceAsStream(path);
        if (data == null) {
            log.error("System Avatar not found at the following resource path: " + path);
            throw new IOException("File not found");
        }
        return data;
    }

    private String getIconPath(Avatar icon, Avatar.Size size) {
        if (DefaultSystemIconImageProvider.isSvgContentType(icon.getContentType())) {
            return ICON_CLASSPATH_PREFIX + icon.getFileName();
        }
        return ICON_CLASSPATH_PREFIX + AvatarFilenames.getFilenameFlag(size) + icon.getFileName();
    }

    public static boolean isSvgContentType(String mimeType) {
        return "image/svg+xml".equals(mimeType);
    }
}

