/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import io.atlassian.fugue.Option;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueTabPanelInvokerImpl
implements IssueTabPanelInvoker {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelInvokerImpl.class);
    private final I18nHelper.BeanFactory i18Factory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTabPanelInvokerImpl(I18nHelper.BeanFactory i18Factory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.i18Factory = i18Factory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public boolean invokeShowPanel(final ShowPanelRequest request, final IssueTabPanelModuleDescriptor descriptor) {
        try (Ticker ignored = Timers.start((String)("Calling showPanel for " + descriptor));){
            Option showPanel = Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
                    try {
                        return issueTabPanel.showPanel(request);
                    }
                    catch (AbstractMethodError e) {
                        log.error(IssueTabPanelInvokerImpl.this.formatBinaryCompatibilityMessage(issueTabPanel, "showPanel"), (Throwable)e);
                        return true;
                    }
                }
            }).getOrNull());
            if (showPanel.isEmpty()) {
                log.error("Exception thrown while trying to call showPanel() for {}", (Object)descriptor);
                boolean bl = true;
                return bl;
            }
            boolean bl = (Boolean)showPanel.get();
            return bl;
        }
    }

    @Override
    public List<IssueAction> invokeGetActions(final GetActionsRequest request, final IssueTabPanelModuleDescriptor descriptor) {
        try (Ticker ignored = Timers.start((String)("Calling getActions in" + descriptor));){
            Option actions = Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<List<IssueAction>>(){

                @Override
                public List<IssueAction> call() throws Exception {
                    IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
                    try {
                        return issueTabPanel.getActions(request);
                    }
                    catch (AbstractMethodError e) {
                        log.error(IssueTabPanelInvokerImpl.this.formatBinaryCompatibilityMessage(issueTabPanel, "getActions"), (Throwable)e);
                        return Collections.singletonList(new RenderingErrorAction(descriptor));
                    }
                }
            }).getOrNull());
            if (actions.isEmpty()) {
                log.error("Exception thrown while trying to call getActions() for {}", (Object)descriptor);
            }
            List list = (List)actions.getOrElse(Collections.singletonList(new RenderingErrorAction(descriptor)));
            return list;
        }
    }

    private String formatBinaryCompatibilityMessage(IssueTabPanel3 issueTabPanel, String methodName) {
        return String.format("%s does not implement IssueTabPanel.%s(com.atlassian.jira.issues.Issue, com.atlassian.crowd.embedded.api.User). This likely means the plugin is not compatible with this version of JIRA.", methodName, issueTabPanel.getClass().getName());
    }

    class RenderingErrorAction
    implements IssueAction {
        private final IssueTabPanelModuleDescriptor moduleDescriptor;

        public RenderingErrorAction(IssueTabPanelModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        public String getHtml() {
            return IssueTabPanelInvokerImpl.this.i18Factory.getInstance(IssueTabPanelInvokerImpl.this.jiraAuthenticationContext.getUser()).getText("modulewebcomponent.exception", this.moduleDescriptor.getCompleteKey());
        }

        public java.util.Date getTimePerformed() {
            return new Date(System.currentTimeMillis());
        }

        public boolean isDisplayActionAllTab() {
            return true;
        }
    }
}

